/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfPort;

public class Autofix_SVTB_1_1_23
extends VerissimoAutofix {
    public Autofix_SVTB_1_1_23(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            try {
                VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
                if (additionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object object = additionalInfo.getElement();
                if (!(object instanceof RfInterface)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                RfInterface interfaceElem = (RfInterface)object;
                ArrayList<IRfPortElement> localPorts = new ArrayList<IRfPortElement>(interfaceElem.getLocalPorts());
                if (localPorts == null || localPorts.isEmpty()) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                String lineDelimiter = document.getLineDelimiter(0);
                String lineIndent = "";
                RfPort firstPort = (RfPort)localPorts.get(0);
                int startOffsetForFirstPort = firstPort.getStartOffset();
                int lineOffset = document.getLineOffset(firstPort.getLine() - 1);
                lineIndent = VerissimoAutofixEditsUtils.INSTANCE.getIndent(lineOffset, document);
                int openParenthesisOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "(", lineOffset - 1, startOffsetForFirstPort, false);
                if (openParenthesisOffset >= lineOffset) {
                    InsertEditParameters edit = new InsertEditParameters(this, openParenthesisOffset + 1, lineDelimiter, "", lineIndent);
                    this.addEditForHit(hit, file, edit, true);
                }
                RfPort lastPort = (RfPort)localPorts.get(localPorts.size() - 1);
                int lastPortEndOffset = lastPort.getEndOffset();
                int lineLength = document.getLineLength(lastPort.getEndLine() - 1);
                lineOffset = document.getLineOffset(lastPort.getEndLine() - 1);
                lineIndent = VerissimoAutofixEditsUtils.INSTANCE.getIndent(lineOffset, document);
                int closedParenthesisOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ")", lastPortEndOffset, lineOffset + lineLength, true);
                if (closedParenthesisOffset >= lineOffset + lineLength) continue;
                InsertEditParameters edit = new InsertEditParameters(this, closedParenthesisOffset - 1, lineDelimiter, "", lineIndent);
                this.addEditForHit(hit, file, edit, true);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                this.addError(error);
            }
        }
    }
}

