/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;

public class Autofix_SVTB_1_1_24
extends VerissimoAutofix {
    public Autofix_SVTB_1_1_24(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        int hitIdx = 0;
        while (hitIdx < hits.size()) {
            OVMComplianceCheckHit hit = hits.get(hitIdx);
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            } else {
                Object info = autofixAdditionalInfo.getElement();
                if (info instanceof String) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setAdditionalInformation((String)info);
                    this.addError(error);
                } else if (!(info instanceof RfDefElement)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                } else {
                    Object rightmostOffsetObject = autofixAdditionalInfo.getParentElement();
                    if (!(rightmostOffsetObject instanceof Integer)) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    } else {
                        RfDefElement defElement = (RfDefElement)info;
                        Integer rightmostOffset = (Integer)rightmostOffsetObject;
                        this.fixDefElement(hit, file, document, defElement, rightmostOffset);
                    }
                }
            }
            ++hitIdx;
        }
    }

    private void fixDefElement(OVMComplianceCheckHit hit, IFile file, IDocument document, RfDefElement defElement, int rightmostOffset) {
        int offsetFile = defElement.getStartOffset();
        String addedSpaces = Strings.repeat((String)" ", (int)(rightmostOffset - this.getOffsetOnLine(defElement, document)));
        InsertEditParameters edit = new InsertEditParameters(this, offsetFile, addedSpaces);
        this.addEditForHit(hit, file, edit);
    }

    private int getOffsetOnLine(RfDefElement element, IDocument document) {
        int lineStartOffset = 0;
        int offsetOnLine = 0;
        try {
            lineStartOffset = DVTDocumentUtils.convertLineToOffset((IDocument)document, (int)element.getStartLine());
            offsetOnLine = element.getStartOffset() - lineStartOffset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return offsetOnLine;
    }
}

