/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;

public class Autofix_SVTB_1_1_26
extends VerissimoAutofix {
    public Autofix_SVTB_1_1_26(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        try {
            if (hits == null || hits.isEmpty()) {
                return;
            }
            for (OVMComplianceCheckHit hit : hits) {
                VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (hitAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if (!(hitAdditionalInfo.getElement() instanceof Integer) && !(hitAdditionalInfo.getElement() instanceof ArrayList)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if (hitAdditionalInfo.getElement() instanceof ArrayList) {
                    List info = (List)hitAdditionalInfo.getElement();
                    int start = (Integer)info.get(0);
                    int end = (Integer)info.get(1);
                    int j = 2;
                    int i = start;
                    while (i <= end) {
                        int nofSpaces = (Integer)info.get(j);
                        int lineOffset = document.getLineOffset(i - 1);
                        int firstCharOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, lineOffset);
                        ReplaceEditParameters edit = new ReplaceEditParameters(this, lineOffset, firstCharOffset - lineOffset, StringUtils.repeat((String)" ", (int)nofSpaces));
                        this.addEditForHit(hit, file, edit);
                        ++j;
                        ++i;
                    }
                    return;
                }
                int nofSpaces = (Integer)hitAdditionalInfo.getElement();
                int lineOffset = document.getLineOffset(hit.getLine() - 1);
                int firstCharOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, lineOffset);
                ReplaceEditParameters edit = new ReplaceEditParameters(this, lineOffset, firstCharOffset - lineOffset, StringUtils.repeat((String)" ", (int)nofSpaces));
                this.addEditForHit(hit, file, edit);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

