/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.parser.SVTBIssues;

public class Autofix_SVTB_1_1_2_0
extends VerissimoAutofix {
    public Autofix_SVTB_1_1_2_0(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object element = autofixAdditionalInfo.getElement();
            if (!(element instanceof SVTBIssues)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            SVTBIssues issue = (SVTBIssues)autofixAdditionalInfo.getElement();
            String lineOffsetString = issue.getAdditionalInfo();
            if (lineOffsetString == null || issue.getInfo() == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            int lineOffset = Integer.parseInt(lineOffsetString);
            int nofSpaces = Integer.parseInt(issue.getInfo());
            int nofInsertedWhitespaces = 0;
            if (lineOffset % nofSpaces != 0) {
                nofInsertedWhitespaces = nofSpaces - lineOffset % nofSpaces;
            }
            InsertEditParameters edit = new InsertEditParameters(this, issue.getOffset(), StringUtils.repeat((String)" ", (int)nofInsertedWhitespaces));
            this.addEditForHit(hit, file, edit);
        }
    }
}

