/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

public class Autofix_SVTB_1_4_1
extends VerissimoAutofix {
    public Autofix_SVTB_1_4_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            try {
                VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
                if (additionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object issues = additionalInfo.getElement();
                Object prevIssues = additionalInfo.getParentElement();
                if (!(issues instanceof SVTBIssues) || !(prevIssues instanceof SVTBIssues)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                SVTBIssues issue = (SVTBIssues)issues;
                SVTBIssues prevIssue = (SVTBIssues)prevIssues;
                ReparseInfo reparseInfo = issue.getReparseInfo();
                ReparseInfo prevReparseInfo = prevIssue.getReparseInfo();
                if (reparseInfo != null && reparseInfo.equals(prevReparseInfo)) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("it is defined in macro '" + reparseInfo.getLastReparseMacroName() + "'");
                    this.addError(error);
                    continue;
                }
                int lineOffset = document.getLineOffset(hit.getLine() - 1);
                String lineIndent = VerissimoAutofixEditsUtils.INSTANCE.getIndent(lineOffset, document);
                String lineDelimiter = document.getLineDelimiter(0);
                InsertEditParameters edit = new InsertEditParameters(this, issue.getOffset(), lineDelimiter, "", lineIndent);
                this.addEditForHit(hit, file, edit);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                this.addError(error);
            }
        }
    }
}

