/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.parser.ReparseInfo;

public class Autofix_SVTB_1_4_2
extends VerissimoAutofix {
    public Autofix_SVTB_1_4_2(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            try {
                VerissimoAutofixError error;
                VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
                if (additionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object elements = additionalInfo.getElement();
                if (!(elements instanceof ArrayList)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                ArrayList fields = (ArrayList)elements;
                if (fields.isEmpty()) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                RfField firstField = (RfField)fields.get(0);
                if (firstField.getResolvedType(true) instanceof RfStruct) {
                    error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("it is a struct");
                    this.addError(error);
                    continue;
                }
                if (firstField.isImplicit() || firstField.isImplicitSignal()) {
                    error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    this.addError(error);
                    continue;
                }
                RfDefElement declaration = ((RfField)fields.get(0)).getDeclaration();
                ReparseInfo reparseInfo = declaration.getReparseInfo();
                if (reparseInfo != null) {
                    VerissimoAutofixError error2 = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error2.setReason("it is defined in macro '" + reparseInfo.getLastReparseMacroName() + "'");
                    this.addError(error2);
                    continue;
                }
                Collections.sort(fields, new Comparator<RfField>(){

                    @Override
                    public int compare(RfField o1, RfField o2) {
                        return o1.getEndOffset() - o2.getEndOffset();
                    }
                });
                int lineOffset = document.getLineOffset(hit.getLine() - 1);
                String lineIndent = VerissimoAutofixEditsUtils.INSTANCE.getIndent(lineOffset, document);
                String lineDelimiter = document.getLineDelimiter(0);
                List<EditParameters> beginEndEdits = null;
                RfNamedElement enclosingScope = firstField.getEnclosingScope();
                if (enclosingScope instanceof RfGenerateBlock) {
                    beginEndEdits = VerissimoAutofixEditsUtils.INSTANCE.insertBeginEndForGenerateBlock(firstField.getEnclosingScope(), document, this);
                } else if (((RfField)fields.get(0)).getEnclosingScope() instanceof RfActionBlock && !((RfActionBlock)enclosingScope).isSimpleForkJoin()) {
                    beginEndEdits = VerissimoAutofixEditsUtils.INSTANCE.insertBeginEndForActionBlock(firstField.getEnclosingScope(), document, this);
                }
                if (beginEndEdits != null) {
                    this.addEditsForHit(hit, file, beginEndEdits);
                }
                int i = fields.size() - 1;
                while (i > 0) {
                    RfField field = (RfField)fields.get(i);
                    int editStartOffset = -1;
                    int previousCommaOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, ",", lineOffset, field.getStartOffset(), false, false, true);
                    int previousSemicolonOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, ";", lineOffset, field.getStartOffset(), false, false, true);
                    int previousFieldEndOffset = ((RfField)fields.get(i - 1)).getEndOffset();
                    if (previousCommaOffset >= previousFieldEndOffset) {
                        editStartOffset = previousCommaOffset;
                    } else if (previousSemicolonOffset >= previousFieldEndOffset) {
                        editStartOffset = previousSemicolonOffset;
                    }
                    if (editStartOffset != -1) {
                        int replaceLength = field.getStartOffset() - editStartOffset;
                        String replaceString = ";" + lineDelimiter + lineIndent + this.computeFieldCompleteType(field) + " ";
                        ReplaceEditParameters edit = new ReplaceEditParameters(this, editStartOffset, replaceLength, replaceString);
                        this.addEditForHit(hit, file, edit);
                    }
                    --i;
                }
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                this.addError(error);
            }
        }
    }

    private String computeFieldCompleteType(RfField field) {
        DataType packageScope;
        DataType dataType = field.getDataType();
        if (dataType == null) {
            return "";
        }
        String fieldType = "";
        if (field.hasStorageAutomaticQualifier() || field.hasObjectAutomaticQualifier()) {
            fieldType = String.valueOf(fieldType) + "automatic ";
        }
        if (field.hasStorageStaticQualifier() || field.hasObjectStaticQualifier()) {
            fieldType = String.valueOf(fieldType) + "static ";
        }
        if (dataType.isVirtualInterface()) {
            fieldType = String.valueOf(fieldType) + "virtual ";
        }
        if (field.isRand()) {
            fieldType = String.valueOf(fieldType) + "rand ";
        }
        if (field.isRandc()) {
            fieldType = String.valueOf(fieldType) + "randc ";
        }
        if (dataType.getNetType() != null) {
            fieldType = String.valueOf(fieldType) + dataType.getNetType() + " ";
        }
        if ((packageScope = dataType.getPackageScope()) != null) {
            fieldType = String.valueOf(fieldType) + packageScope + "::";
        }
        if (dataType.dependsOnParameters() && dataType.getTypeNameWithParamAssignments() != null) {
            fieldType = String.valueOf(fieldType) + dataType.getTypeNameWithParamAssignments();
        } else if (dataType.getType() != null) {
            fieldType = String.valueOf(fieldType) + dataType.getType();
        }
        if (dataType.getSign() != 0) {
            fieldType = String.valueOf(fieldType) + (dataType.getSign() == 1 ? " signed " : " unsigned ");
        }
        fieldType = String.valueOf(fieldType) + (dataType.hasPackedDimension() ? dataType.getPackedDimensionString() : "");
        return fieldType;
    }
}

