/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class Autofix_SVTB_1_5
extends VerissimoAutofix {
    RfProject rfProject;

    public Autofix_SVTB_1_5(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        this.rfProject = check.getOVMProject().getRfProject();
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        try {
            for (OVMComplianceCheckHit hit : hits) {
                boolean isCaseItem;
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object issue = autofixAdditionalInfo.getElement();
                if (!(issue instanceof SVTBIssues)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                SVTBIssues svtbIssue = (SVTBIssues)issue;
                if (svtbIssue.getReparseInfo() != null) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("the statement is inside a macro");
                    this.addError(error);
                    continue;
                }
                int offset = svtbIssue.getOffset();
                int statementLine = svtbIssue.getLine() - 1;
                int statementLineEndOffset = document.getLineOffset(statementLine + 1);
                int endOffset = -1;
                boolean bl = isCaseItem = (9 & svtbIssue.getCarry()) == 9;
                if (isCaseItem) {
                    endOffset = this.getCaseItemEndOffset(document, offset, hit.getParserPath());
                } else {
                    boolean found = false;
                    IRfScopeElement scope = RfBatchUtils.getRfScope(this.rfProject, hit.getParserPath(), offset);
                    if (scope instanceof RfActionBlockDef) {
                        Collection<RfDefElement> children;
                        RfActionBlockDef actionBlockDef = (RfActionBlockDef)scope;
                        actionBlock = (RfActionBlock)actionBlockDef.getNamedElement();
                        VlogMacroInfo info = RfBatchUtils.getMacro(this.rfProject, hit.getParserPath(), document, actionBlockDef.getEndOffset() + 1);
                        if (info != null) {
                            VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                            error.setReason("the statement contains macro call '" + info.getName() + "'");
                            this.addError(error);
                            continue;
                        }
                        if ((((RfActionBlock)actionBlock).isForkJoin() || ((RfActionBlock)actionBlock).isForkJoinNone() || ((RfActionBlock)actionBlock).isForkJoinAny()) && (children = actionBlockDef.getChildren()) != null) {
                            Iterator<RfDefElement> it = children.iterator();
                            while (it.hasNext()) {
                                String word;
                                RfNamedElement current;
                                Object[] nextToken;
                                int childStartOffset;
                                RfDefElement child = it.next();
                                if (!(child.getNamedElement() instanceof RfActionBlock) || offset != (childStartOffset = VerissimoAutofixEditsUtils.INSTANCE.getActionBlockLabelStartOffset((RfActionBlock)child.getNamedElement(), document))) continue;
                                int crtEndOffset = child.getEndOffset();
                                if (((RfActionBlock)child.getNamedElement()).isDoWhile()) {
                                    crtEndOffset = VerissimoAutofixEditsUtils.INSTANCE.getMatchingRightParenthesesOffset(document, crtEndOffset, document.getLength()) + 1;
                                } else if (((RfActionBlock)child.getNamedElement()).isIf() && (nextToken = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, (crtEndOffset = (current = child.getNamedElement()).getEndOffset()) + 1, true)) != null && nextToken.length > 1 && "else".equals(word = (String)nextToken[1])) {
                                    while (it.hasNext()) {
                                        RfDefElement sibling = it.next();
                                        if (!(sibling.getNamedElement() instanceof RfActionBlock)) continue;
                                        RfActionBlock siblingElement = (RfActionBlock)sibling.getNamedElement();
                                        if (!siblingElement.isElsIf() && !siblingElement.isElse()) break;
                                        crtEndOffset = siblingElement.getEndOffset();
                                    }
                                }
                                endOffset = document.getChar(crtEndOffset) == ';' ? VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetOfPreviousStatement(this.rfProject, file, document, crtEndOffset + 1, true) : VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetOfPreviousStatement(this.rfProject, file, document, crtEndOffset, true);
                                found = true;
                                break;
                            }
                        }
                        if (!found && ((RfActionBlock)actionBlock).isSimpleForkJoin()) {
                            if (statementLine + 1 != actionBlockDef.getEndLine()) {
                                endOffset = VerissimoAutofixEditsUtils.INSTANCE.getStartOffsetOfNextStatement(document, offset);
                                found = true;
                            } else {
                                endOffset = VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetOfPreviousStatement(this.rfProject, file, document, actionBlockDef.getEndOffset() + 1, false);
                                found = true;
                            }
                        } else if (!found && (((RfActionBlock)actionBlock).isForkJoin() || ((RfActionBlock)actionBlock).isForkJoinNone() || ((RfActionBlock)actionBlock).isForkJoinAny() || ((RfActionBlock)actionBlock).isForever())) {
                            if (((RfActionBlock)actionBlock).isForever() || VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, offset, true)[1].toString().equals("fork")) {
                                endOffset = VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetOfPreviousStatement(this.rfProject, file, document, actionBlockDef.getEndOffset() + 1, true);
                                found = true;
                            } else {
                                endOffset = statementLineEndOffset;
                                found = true;
                            }
                        }
                        if (!found) {
                            endOffset = document.getChar(actionBlockDef.getEndOffset()) == ';' ? VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetOfPreviousStatement(this.rfProject, file, document, actionBlockDef.getEndOffset() + 1, true) : VerissimoAutofixEditsUtils.INSTANCE.getEndOffsetOfPreviousStatement(this.rfProject, file, document, actionBlockDef.getEndOffset(), true);
                            found = true;
                        }
                    } else if (scope instanceof RfGenerateBlockDef) {
                        String word;
                        VlogMacroInfo info = RfBatchUtils.getMacro(this.rfProject, hit.getParserPath(), document, ((RfGenerateBlockDef)scope).getEndOffset() + 1);
                        if (info != null) {
                            VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                            error.setReason("statement contains macro call '" + info.getName() + "'");
                            this.addError(error);
                            continue;
                        }
                        actionBlock = (RfGenerateBlock)((RfGenerateBlockDef)scope).getNamedElement();
                        endOffset = actionBlock.getEndOffset();
                        Object[] nextToken = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, endOffset, true);
                        if (nextToken != null && nextToken.length > 1 && ("endcase".equals(word = (String)nextToken[1]) || ";".equals(word))) {
                            endOffset = (Integer)nextToken[0] + word.length();
                        }
                        found = true;
                    }
                    if (!found) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        continue;
                    }
                }
                String statementLineIndent = VerissimoAutofixEditsUtils.INSTANCE.getIndentOfLine(statementLine, document);
                if (hit.getDetails().equals("Next line should be empty or contain only whitespaces!")) {
                    InsertEditParameters edit = new InsertEditParameters(this, endOffset, "\n");
                    this.addEditForHit(hit, file, edit, true);
                    continue;
                }
                InsertEditParameters edit1 = new InsertEditParameters(this, offset, "begin\n" + statementLineIndent + "\t");
                this.addEditForHit(hit, file, edit1, true);
                InsertEditParameters edit2 = new InsertEditParameters(this, endOffset, "\n" + statementLineIndent + "end\n");
                this.addEditForHit(hit, file, edit2, true);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private int getCaseItemEndOffset(IDocument document, int offset, ParserPath pp) {
        IRfScopeElement initialElementScopeAtEndOffset = RfBatchUtils.getRfScope(this.rfProject, pp, offset + 1);
        RfNamedElement initialElement = null;
        if (initialElementScopeAtEndOffset instanceof RfActionBlockDef) {
            initialElement = ((RfActionBlockDef)initialElementScopeAtEndOffset).getNamedElement();
        } else if (initialElementScopeAtEndOffset instanceof RfGenerateBlockDef) {
            initialElement = ((RfGenerateBlockDef)initialElementScopeAtEndOffset).getNamedElement();
        }
        RfNamedElement caseScope = null;
        if (initialElement instanceof RfAbstractBlock) {
            caseScope = ((RfAbstractBlock)initialElement).getEnclosingScope();
        }
        int endOffset = VerissimoAutofixEditsUtils.INSTANCE.getStartOffsetOfNextStatement(document, offset + 1);
        IRfScopeElement elementScopeAtEndOffset = RfBatchUtils.getRfScope(this.rfProject, pp, endOffset);
        while (elementScopeAtEndOffset instanceof RfActionBlockDef) {
            Object[] nextToken;
            RfNamedElement elementAtEndOffset = ((RfActionBlockDef)elementScopeAtEndOffset).getNamedElement();
            if (!(elementAtEndOffset instanceof RfAbstractBlock)) continue;
            RfAbstractBlock abstractBlock = (RfAbstractBlock)elementAtEndOffset;
            if (initialElement != null && ((RfActionBlockDef)elementScopeAtEndOffset).getStartOffset() > initialElement.getDeclaration().getEndOffset()) break;
            if (abstractBlock.isCaseItem()) {
                RfNamedElement enclosingScope = abstractBlock.getEnclosingScope();
                if (initialElement != null && (initialElement.equals(enclosingScope) || !initialElement.equals(abstractBlock) && enclosingScope.equals(caseScope))) break;
            }
            if ((abstractBlock.isCase() || abstractBlock.isRandCase()) && initialElement instanceof RfAbstractBlock) {
                RfNamedElement initialEnclosingScope = ((RfAbstractBlock)initialElement).getEnclosingScope();
                boolean found = false;
                while (initialEnclosingScope != null) {
                    if (abstractBlock.equals(initialEnclosingScope)) {
                        found = true;
                        break;
                    }
                    initialEnclosingScope = initialEnclosingScope.getEnclosingScope();
                }
                if (found) break;
            }
            if ((nextToken = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, (endOffset = abstractBlock.getEndOffset()) + 1, true)) == null || nextToken.length < 2) break;
            String nextTokenWord = (String)nextToken[1];
            int nextTokenEndOffset = (Integer)nextToken[0] + nextTokenWord.length();
            elementScopeAtEndOffset = RfBatchUtils.getRfScope(this.rfProject, pp, nextTokenEndOffset);
        }
        return endOffset;
    }
}

