/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

public class Autofix_SVTB_1_5_1
extends VerissimoAutofix {
    private static final String FOREACH = "foreach";
    private static final String IF = "if";
    private static final String ELSE = "else";

    public Autofix_SVTB_1_5_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, final IFile file, final IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (final OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
            if (additionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object issues = additionalInfo.getElement();
            if (!(issues instanceof SVTBIssues)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            SVTBIssues issue = (SVTBIssues)issues;
            ReparseInfo reparseInfo = issue.getReparseInfo();
            if (reparseInfo != null) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("it contains a macro call '" + reparseInfo.getLastReparseMacroName() + "'");
                this.addError(error);
                continue;
            }
            final int issueOffset = issue.getOffset();
            IRfScopeElement scopeElement = RfBatchUtils.getRfScope(this.getRfProject(), hit.getParserPath(), issueOffset);
            if (scopeElement == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!(scopeElement instanceof RfConstraintDef) && !(scopeElement instanceof RfActionBlockDef)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfDefElement defElement = (RfDefElement)scopeElement;
            final RfNamedElement namedElement = defElement.getNamedElement();
            final String issueInfo = issue.getInfo();
            if (FOREACH.equals(issueInfo)) {
                this.computeForeachEdits(file, document, hit, scopeElement, namedElement);
                continue;
            }
            final Autofix_SVTB_1_5_1 autofix = this;
            namedElement.visitHidObject(null, new IHidVisitor<RfHidOperator>(){
                private boolean alreadyAddedHit;

                public boolean visit(RfHidOperator operator) {
                    if (this.alreadyAddedHit) {
                        return true;
                    }
                    if (Autofix_SVTB_1_5_1.IF.equals(issueInfo) || Autofix_SVTB_1_5_1.ELSE.equals(issueInfo)) {
                        if (!operator.isIfElseStatement() || issueOffset < operator.getOpenBoundary() || issueOffset > operator.getCloseBoundary()) {
                            return true;
                        }
                        int endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", issueOffset, document.getLength(), false);
                        InsertEditParameters openEdit = new InsertEditParameters(autofix, issueOffset + (Autofix_SVTB_1_5_1.IF.equals(issueInfo) ? 1 : 4), " {");
                        InsertEditParameters closeEdit = new InsertEditParameters(autofix, endOffset, " }");
                        Autofix_SVTB_1_5_1.this.addEditForHit(hit, file, openEdit, true);
                        Autofix_SVTB_1_5_1.this.addEditForHit(hit, file, closeEdit, true);
                    } else {
                        int constraintEndOffset;
                        int nextSemicolonOffset;
                        int hidOffset = operator.getOccurrence().getOffset();
                        if (hidOffset != issueOffset) {
                            return true;
                        }
                        ListContainer rhValues = operator.getRHValues();
                        if (this.hasMacroCallInHids(hit, (ListContainer<IHidObject>)rhValues)) {
                            return true;
                        }
                        int startOffset = issueOffset + operator.getOperatorText().length();
                        InsertEditParameters openEdit = new InsertEditParameters(autofix, startOffset, " {");
                        Autofix_SVTB_1_5_1.this.addEditForHit(hit, file, openEdit, true);
                        int endOffset = namedElement.getEndOffset();
                        if (namedElement.getImplementation() != null) {
                            endOffset = namedElement.getImplementation().getEndOffset();
                        }
                        if ((nextSemicolonOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", startOffset, constraintEndOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "}", endOffset, document.getLength(), false), false)) < constraintEndOffset) {
                            InsertEditParameters closeEdit = new InsertEditParameters(autofix, nextSemicolonOffset, " }");
                            Autofix_SVTB_1_5_1.this.addEditForHit(hit, file, closeEdit, true);
                            return true;
                        }
                        InsertEditParameters closeEdit = new InsertEditParameters(autofix, operator.getCloseBoundary(), " }");
                        Autofix_SVTB_1_5_1.this.addEditForHit(hit, file, closeEdit, true);
                    }
                    this.alreadyAddedHit = true;
                    return true;
                }

                private boolean hasMacroCallInHids(OVMComplianceCheckHit hit2, ListContainer<IHidObject> rhValues) {
                    if (rhValues == null) {
                        return false;
                    }
                    boolean result = false;
                    for (IHidObject rhValue : rhValues) {
                        IReparseInfo reparseInfo;
                        if (!(rhValue instanceof RfHidOperator) && !(rhValue instanceof RfHid)) continue;
                        IReparseInfo iReparseInfo = reparseInfo = rhValue instanceof RfHidOperator ? ((RfHidOperator)rhValue).getReparseInfo() : ((RfHid)rhValue).getReparseInfo();
                        if (reparseInfo != null) {
                            VerissimoAutofixError error = new VerissimoAutofixError(hit2, VerissimoAutofixErrorType.UNFIXABLE);
                            error.setReason("it contains a macro call '" + reparseInfo.getLastReparseMacroName() + "'");
                            Autofix_SVTB_1_5_1.this.addError(error);
                            return true;
                        }
                        if (!(rhValue instanceof RfHidOperator)) continue;
                        result = result || this.hasMacroCallInHids(hit2, (ListContainer<IHidObject>)((RfHidOperator)rhValue).getLHValue());
                        boolean bl = result = result || this.hasMacroCallInHids(hit2, (ListContainer<IHidObject>)((RfHidOperator)rhValue).getRHValues());
                    }
                    return result;
                }

                public Class<RfHidOperator> getType() {
                    return RfHidOperator.class;
                }
            });
        }
    }

    private void computeForeachEdits(IFile file, IDocument document, OVMComplianceCheckHit hit, IRfScopeElement scopeElement, RfNamedElement namedElement) {
        if (!(scopeElement instanceof RfActionBlockDef)) {
            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            return;
        }
        RfActionBlock actionBlock = (RfActionBlock)namedElement;
        int openParenForExpression = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "(", actionBlock.getOffset(), actionBlock.getEndOffset(), true);
        int closeParenForExpression = VerissimoAutofixEditsUtils.INSTANCE.getMatchingRightParenthesesOffset(document, openParenForExpression, actionBlock.getEndOffset());
        if (closeParenForExpression >= actionBlock.getEndOffset()) {
            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            return;
        }
        InsertEditParameters openEdit = new InsertEditParameters(this, closeParenForExpression + 1, " {");
        this.addEditForHit(hit, file, openEdit, true);
        InsertEditParameters closeEdit = new InsertEditParameters(this, actionBlock.getEndOffset(), " }");
        this.addEditForHit(hit, file, closeEdit, true);
    }
}

