/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.parser.SVTBIssues;

public class Autofix_SVTB_1_5_2
extends VerissimoAutofix {
    private boolean allowLinesWithComments;

    public Autofix_SVTB_1_5_2(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        this.allowLinesWithComments = VerissimoAutofixUtils.getInstance().getParameterValueAsBoolean(check, "allowLinesWithComments");
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        try {
            for (OVMComplianceCheckHit hit : hits) {
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object element = autofixAdditionalInfo.getElement();
                if (!(element instanceof SVTBIssues)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object parentElement = autofixAdditionalInfo.getParentElement();
                if (!(parentElement instanceof RfActionBlock)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                SVTBIssues issue = (SVTBIssues)element;
                if (issue.getReparseInfo() != null) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("it uses a macro call");
                    this.addError(error);
                    continue;
                }
                RfActionBlock actionBlock = (RfActionBlock)parentElement;
                RfDefElement declaration = actionBlock.getDeclaration();
                if (!(declaration instanceof RfActionBlockDef)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                int lineWhereIfCloses = actionBlock.getDeclaration().getStartLine();
                int statementLine = issue.getLine();
                int ifOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "if", 0, issue.getOffset(), false);
                String replacement = "";
                int editStartOffset = -1;
                int editEndOffset = -1;
                if (lineWhereIfCloses + 1 < statementLine) {
                    int previousCharOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, issue.getOffset() - 1, !this.allowLinesWithComments) + 1;
                    int ifContentStartOffset = VerissimoAutofixEditsUtils.INSTANCE.getContentStartOffsetInsideScope(actionBlock, document);
                    String partition = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", previousCharOffset - 1, false);
                    if (previousCharOffset > ifContentStartOffset && partition.equals("__dftl_partition_content_type")) {
                        VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                        error.setReason("other code statements were found between 'if' and the single line statement");
                        this.addError(error);
                        continue;
                    }
                    replacement = "\n" + this.getIndentation(document, actionBlock, ifOffset);
                    editStartOffset = previousCharOffset;
                    editEndOffset = issue.getOffset();
                    if (editEndOffset < 0 || editStartOffset < 0) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        continue;
                    }
                    ReplaceEditParameters edit = new ReplaceEditParameters(this, editStartOffset, editEndOffset - editStartOffset, replacement);
                    this.addEditForHit(hit, file, edit);
                    if (!this.allowLinesWithComments) continue;
                    int lastNewLineOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "\n", ifContentStartOffset, issue.getOffset() - 1, true, false, false);
                    while (lastNewLineOffset > ifContentStartOffset) {
                        String inBetween;
                        int prevNewLineOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "\n", ifContentStartOffset, lastNewLineOffset - 1, true, false, false);
                        if (prevNewLineOffset > ifContentStartOffset && (inBetween = document.get(prevNewLineOffset, lastNewLineOffset - prevNewLineOffset + 1)).trim().isEmpty()) {
                            DeleteEditParameters delEdit = new DeleteEditParameters(this, prevNewLineOffset, lastNewLineOffset - prevNewLineOffset);
                            this.addEditForHit(hit, file, delEdit);
                        }
                        lastNewLineOffset = prevNewLineOffset;
                    }
                    continue;
                }
                int statementLineOffset = document.getLineOffset(statementLine - 1);
                int firstCharOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, statementLineOffset, false);
                replacement = this.getIndentation(document, actionBlock, ifOffset);
                editStartOffset = statementLineOffset;
                editEndOffset = firstCharOffset;
                if (editEndOffset < 0 || editStartOffset < 0) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                ReplaceEditParameters edit = new ReplaceEditParameters(this, editStartOffset, editEndOffset - editStartOffset, replacement);
                this.addEditForHit(hit, file, edit);
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private String getIndentation(IDocument document, RfNamedElement actionBlock, int offset) {
        try {
            int startLine = document.getLineOfOffset(offset);
            String indent = String.valueOf(VerissimoAutofixEditsUtils.INSTANCE.getIndentOfLine(startLine, document)) + VerissimoAutofixEditsUtils.INSTANCE.getBlockIndentation(document, actionBlock);
            if (!indent.isEmpty()) {
                return indent;
            }
            return "\t";
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }
}

