/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.utils.LiteralToken;

public class Autofix_SVTB_1_5_3
extends VerissimoAutofix {
    public Autofix_SVTB_1_5_3(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        try {
            int hitIdx = 0;
            while (hitIdx < hits.size()) {
                OVMComplianceCheckHit hit = hits.get(hitIdx);
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                } else {
                    LiteralToken currentLocation = (LiteralToken)autofixAdditionalInfo.getElement();
                    LiteralToken desiredLocation = (LiteralToken)autofixAdditionalInfo.getParentElement();
                    if (currentLocation == null || desiredLocation == null) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    } else {
                        int desiredLine = desiredLocation.getLineNumber() - 1;
                        int currentLine = currentLocation.getLineNumber() - 1;
                        int startOffset = document.getLineOffset(desiredLine) + desiredLocation.getOffsetLine() + desiredLocation.getLength();
                        int currentOffset = document.getLineOffset(currentLine) + currentLocation.getOffsetLine();
                        int length = currentOffset - startOffset;
                        if (desiredLocation.getStringToken().charAt(desiredLocation.getLength() - 1) == '}') {
                            ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffset, length, " ");
                            this.addEditForHit(hit, file, edit);
                        } else {
                            DeleteEditParameters delete;
                            InsertEditParameters insert = new InsertEditParameters(this, startOffset, " {");
                            if (currentLocation.isLastTokenOnLine() && currentLocation.getStringToken().equals("{")) {
                                int currentLineOffset = document.getLineOffset(currentLine);
                                int currentLineLength = document.getLineLength(currentLine);
                                delete = new DeleteEditParameters(this, currentLineOffset, currentLineLength);
                            } else {
                                delete = new DeleteEditParameters(this, currentOffset, 1);
                            }
                            ArrayList<EditParameters> edits = new ArrayList<EditParameters>();
                            edits.add(insert);
                            edits.add(delete);
                            this.addEditsForHit(hit, file, edits);
                        }
                    }
                }
                ++hitIdx;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

