/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;

public class Autofix_SVTB_1_8
extends VerissimoAutofix {
    public Autofix_SVTB_1_8(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object hitLine = autofixAdditionalInfo.getElement();
            if (!(hitLine instanceof Integer)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object hitOffsetInLine = autofixAdditionalInfo.getParentElement();
            if (!(hitOffsetInLine instanceof Integer)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            int startOffset = 0;
            int offsetInDocument = 0;
            try {
                startOffset = document.getLineOffset((Integer)hitLine - 1);
                offsetInDocument = startOffset + (Integer)hitOffsetInLine - 1;
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ReplaceEditParameters edit = new ReplaceEditParameters(this, offsetInDocument, 1, " ");
            this.addEditForHit(hit, file, edit);
        }
    }
}

