/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;

public class Autofix_SVTB_25_10
extends VerissimoAutofix {
    private String commentStyle;

    public Autofix_SVTB_25_10(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        this.commentStyle = VerissimoAutofixUtils.getInstance().getParameterValueAsString(check, "commentStyle");
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        try {
            if (hits == null || hits.isEmpty()) {
                return;
            }
            for (OVMComplianceCheckHit hit : hits) {
                VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (hitAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if (!(hitAdditionalInfo.getElement() instanceof String)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                String currentCommentStyle = (String)hitAdditionalInfo.getElement();
                int lineOffset = document.getLineOffset(hit.getLine() - 1);
                int lineLength = document.getLineLength(hit.getLine() - 1);
                String lineContent = document.get(lineOffset, lineLength);
                int startOffset = lineOffset + lineContent.indexOf(currentCommentStyle);
                ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffset, currentCommentStyle.length(), this.commentStyle);
                this.addEditForHit(hit, file, edit);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

