/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_27_13;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;

public class Autofix_SVTB_27_13
extends VerissimoAutofix {
    private static final String END_LABEL_KEYWORD = "$keyword";
    private static final String END_LABEL = "$label";
    private final String endLabelPatternReplaced;
    private static final Pattern REGEX_REMOVE_NOT_MANDATORY = Pattern.compile("\\\\[stn][*?]");
    private static final Pattern REGEX_ADD_SPACE = Pattern.compile("\\\\s[+]?");
    private static final Pattern REGEX_ADD_TAB = Pattern.compile("\\\\t[+]?");
    private static final Pattern REGEX_ADD_LINE = Pattern.compile("\\\\n[+]?");
    private static final Pattern REGEX_REMOVE_REST = Pattern.compile("\\\\.[?*+]?");
    private final boolean checkEndLabelName = VerissimoAutofixUtils.getInstance().getParameterValueAsBoolean(this.getCheck(), "checkEndLabelName");

    public Autofix_SVTB_27_13(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        String endLabelPattern = VerissimoAutofixUtils.getInstance().getParameterValueAsString(this.getCheck(), "endLabelPattern");
        String endLabelPatternStr = endLabelPattern.replace(END_LABEL, "").replace(END_LABEL_KEYWORD, "");
        endLabelPatternStr = REGEX_REMOVE_NOT_MANDATORY.matcher(endLabelPatternStr).replaceAll("");
        endLabelPatternStr = REGEX_ADD_SPACE.matcher(endLabelPatternStr).replaceAll(" ");
        endLabelPatternStr = REGEX_ADD_TAB.matcher(endLabelPatternStr).replaceAll("\t");
        endLabelPatternStr = REGEX_ADD_LINE.matcher(endLabelPatternStr).replaceAll("\n");
        this.endLabelPatternReplaced = endLabelPatternStr = REGEX_REMOVE_REST.matcher(endLabelPatternStr).replaceAll("");
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        int hitIdx = 0;
        while (hitIdx < hits.size()) {
            OVMComplianceCheckHit hit = hits.get(hitIdx);
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            } else if (autofixAdditionalInfo.getElement() instanceof Check_SVTB_27_13.UnfixableAutofixInfo) {
                VerissimoAutofixError autofixError = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                autofixError.setReason(((Check_SVTB_27_13.UnfixableAutofixInfo)autofixAdditionalInfo.getElement()).getReason());
                this.addError(autofixError);
            } else if (autofixAdditionalInfo.getElement() instanceof Check_SVTB_27_13.InactiveCodeAutofixInfo) {
                Check_SVTB_27_13.InactiveCodeAutofixInfo deadCodeAutofixInfo = (Check_SVTB_27_13.InactiveCodeAutofixInfo)autofixAdditionalInfo.getElement();
                if (this.endLabelPatternReplaced == null || this.endLabelPatternReplaced.isEmpty()) {
                    if (deadCodeAutofixInfo.getEndBlockWithLabelName().isEmpty()) {
                        edit = new InsertEditParameters(this, deadCodeAutofixInfo.getEndBlockOffset(), " : " + deadCodeAutofixInfo.getBlockName());
                        this.addEditForHit(hit, file, edit);
                    } else {
                        String label = deadCodeAutofixInfo.getEndBlockWithLabelName().split(":")[1].trim();
                        ReplaceEditParameters edit = new ReplaceEditParameters(this, deadCodeAutofixInfo.getEndBlockOffset() + deadCodeAutofixInfo.getEndBlockWithLabelName().length() - label.length(), label.length(), deadCodeAutofixInfo.getBlockName());
                        this.addEditForHit(hit, file, edit);
                    }
                } else if (deadCodeAutofixInfo.getEndBlockWithLabelName().isEmpty()) {
                    edit = new InsertEditParameters(this, deadCodeAutofixInfo.getEndBlockOffset(), String.valueOf(this.endLabelPatternReplaced) + deadCodeAutofixInfo.getBlockName());
                    this.addEditForHit(hit, file, edit);
                } else {
                    String finalEndLabelText = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)deadCodeAutofixInfo.getEndBlockWithLabelName(), (String)"");
                    String actualLabel = finalEndLabelText.substring(finalEndLabelText.indexOf(":"), finalEndLabelText.length());
                    if (this.checkEndLabelName) {
                        finalEndLabelText = finalEndLabelText.replace(actualLabel, ":" + deadCodeAutofixInfo.getBlockName());
                    }
                    finalEndLabelText = finalEndLabelText.replace(":", this.endLabelPatternReplaced);
                    edit = new ReplaceEditParameters(this, deadCodeAutofixInfo.getEndBlockOffset(), deadCodeAutofixInfo.getEndBlockWithLabelName().length(), finalEndLabelText);
                    this.addEditForHit(hit, file, edit);
                }
            } else {
                RfDefElement defElement = (RfDefElement)autofixAdditionalInfo.getElement();
                String name = defElement.getName();
                if (defElement instanceof RfGenerateBlockDef) {
                    VerissimoAutofixError autofixError = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    autofixError.setReason("end label is attached to a generate block");
                    this.addError(autofixError);
                } else if (this.endLabelPatternReplaced == null || this.endLabelPatternReplaced.isEmpty()) {
                    if (defElement.hasEndLabel()) {
                        endLabelText = (String)autofixAdditionalInfo.getParentElement();
                        if (endLabelText == null) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        } else {
                            String label = endLabelText.split(":")[1].trim();
                            ReplaceEditParameters edit = new ReplaceEditParameters(this, defElement.getEndOffset() + endLabelText.length() - label.length(), label.length(), name);
                            this.addEditForHit(hit, file, edit);
                        }
                    } else {
                        nextTextToken = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, defElement.getEndOffset(), true);
                        if (nextTextToken == null || nextTextToken.length < 2) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        } else {
                            edit = new InsertEditParameters(this, defElement.getEndOffset() + ((String)nextTextToken[1]).length(), " : " + name);
                            this.addEditForHit(hit, file, edit);
                        }
                    }
                } else if (defElement.hasEndLabel()) {
                    endLabelText = (String)autofixAdditionalInfo.getParentElement();
                    if (endLabelText == null) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    } else {
                        String finalEndLabelText = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)endLabelText, (String)"");
                        String actualLabel = finalEndLabelText.substring(finalEndLabelText.indexOf(":"), finalEndLabelText.length());
                        if (this.checkEndLabelName) {
                            finalEndLabelText = finalEndLabelText.replace(actualLabel, ":" + name);
                        }
                        finalEndLabelText = finalEndLabelText.replace(":", this.endLabelPatternReplaced);
                        ReplaceEditParameters edit = new ReplaceEditParameters(this, defElement.getEndOffset(), endLabelText.length(), finalEndLabelText);
                        this.addEditForHit(hit, file, edit);
                    }
                } else {
                    nextTextToken = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, defElement.getEndOffset(), true);
                    if (nextTextToken == null || nextTextToken.length < 2) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    } else {
                        edit = new InsertEditParameters(this, defElement.getEndOffset() + ((String)nextTextToken[1]).length(), String.valueOf(this.endLabelPatternReplaced) + name);
                        this.addEditForHit(hit, file, edit);
                    }
                }
            }
            ++hitIdx;
        }
    }
}

