/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.RenameAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;

public class Autofix_SVTB_27_6_1
extends RenameAutofix {
    public Autofix_SVTB_27_6_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VlogRenameRefactorInfo refactorInfo = this.computeRefactorInfoForHit(hit, file);
            if (refactorInfo == null) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason(this.computeErrorReason(hit));
                this.addError(error);
                continue;
            }
            refactorInfo.setNewName(this.getNewName(hit));
            this.rename(this, hit, refactorInfo);
        }
    }

    @Override
    public String getNewName(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof SVTBIssues)) {
            return null;
        }
        return ((SVTBIssues)element).getInfo().toUpperCase();
    }

    @Override
    public IStatus checkIfValidName(String name) {
        if (name.equals(name.toUpperCase())) {
            return Status.OK_STATUS;
        }
        return new Status(4, "ro.amiq.vlogdt", "New name must be capitalized.");
    }

    private String computeErrorReason(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof SVTBIssues)) {
            return null;
        }
        ReparseInfo reparseInfo = ((SVTBIssues)element).getReparseInfo();
        if (reparseInfo == null) {
            return null;
        }
        String macroName = reparseInfo.getLastReparseMacroName();
        return "it is defined in macro '" + macroName + "'";
    }
}

