/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofixBeforeEdits;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.base.annotations.AutofixParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;

public class Autofix_SVTB_2_12
extends UserInputAutofixBeforeEdits {
    private static final String IFNDEF = "`ifndef";
    private static final String IFDEF = "`ifdef";
    private static final String DEFINE = "`define";
    private static final String ENDIF = "`endif";
    private static final Pattern IFNDEF_PATTERN = Pattern.compile("^\\s*`ifndef\\s+([a-zA-Z_{1}][a-zA-Z0-9_]+)\\s*$");
    private static final Pattern DEFINE_PATTERN = Pattern.compile("^\\s*`define\\s+([a-zA-Z_{1}][a-zA-Z0-9_]+)\\s*$");
    protected static final String REPLACE = "replace";
    protected static final String WRAP = "wrap";
    private String endIfComment;
    @AutofixParameter(defaultValue="wrap", description="Replace wrong `include guards where possible or wrap existing code. One of the following: 'wrap' or 'replace'.", name="guardMethod", guiPrompt="Replace wrong `include guards where possible or wrap existing code:", allowedValues={"wrap", "replace"}, type=CheckParameterType.STRING)
    public String guardMethod;

    public Autofix_SVTB_2_12(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
        this.endIfComment = VerissimoAutofixUtils.getInstance().getParameterValueAsString(check, "endIfComment");
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            try {
                EditParameters edit2;
                VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (hitAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if (!(hitAdditionalInfo.getElement() instanceof String) || !(hitAdditionalInfo.getParentElement() instanceof String)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                int startOffset = document.getLineOffset(hit.getLine() - 1);
                String content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", startOffset, false);
                if (!"__dftl_partition_content_type".equals(content)) {
                    startOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, startOffset, true);
                }
                if (startOffset < 0 || startOffset == document.getLength()) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                String defineName = (String)hitAdditionalInfo.getElement();
                String guardText = (String)hitAdditionalInfo.getParentElement();
                if (DEFINE.equals(guardText)) {
                    StringBuilder textToInsert = new StringBuilder().append(DEFINE).append(" ").append(defineName);
                    InsertEditParameters edit = new InsertEditParameters(this, startOffset, textToInsert.toString(), "", "\n");
                    this.addEditForHit(hit, file, edit);
                    this.checkEndif(file, document, hit, startOffset, defineName);
                    continue;
                }
                if (ENDIF.equals(guardText)) {
                    int end = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ENDIF, startOffset, document.getLength(), false);
                    int start = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousWhitespace(document, end - 1);
                    String endIf = document.get(start + 1, end - start - 1);
                    if (endIf == null || !endIf.equals(ENDIF)) {
                        InsertEditParameters edit = new InsertEditParameters(this, document.getLength(), "`endif " + this.getEndIfComment(this.endIfComment, defineName), "\n", "");
                        this.addEditForHit(hit, file, edit);
                    }
                    if ((start = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, end)) + 1 < document.getLength() && document.getChar(start) == '/' && document.getChar(start + 1) == '/') {
                        int line = document.getLineOfOffset(start);
                        int startOffsetLine = document.getLineOffset(line);
                        int endOffsetLine = startOffsetLine + document.getLineLength(line);
                        edit2 = new ReplaceEditParameters(this, start, endOffsetLine - start, this.getEndIfComment(this.endIfComment, defineName));
                        this.addEditForHit(hit, file, edit2);
                        continue;
                    }
                    InsertEditParameters edit22 = new InsertEditParameters(this, end, this.getEndIfComment(this.endIfComment, defineName), " ", "\n");
                    this.addEditForHit(hit, file, edit22);
                    continue;
                }
                if (this.guardMethod.equals(REPLACE)) {
                    int lineLength = document.getLineOffset(hit.getLine()) - startOffset;
                    String ifndefName = this.getNameFromPattern(document, IFNDEF_PATTERN, startOffset, lineLength);
                    int defineStartOffset = document.getLineOffset(hit.getLine());
                    int defineLineLength = document.getLineOffset(hit.getLine() + 1) - defineStartOffset;
                    String oldDefineName = this.getNameFromPattern(document, DEFINE_PATTERN, defineStartOffset, defineLineLength);
                    if (ifndefName != null && oldDefineName != null) {
                        ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffset, lineLength, IFNDEF + " " + defineName + "\n");
                        this.addEditForHit(hit, file, edit);
                        if (oldDefineName.equals(ifndefName)) {
                            edit2 = new ReplaceEditParameters(this, defineStartOffset, defineLineLength, DEFINE + " " + defineName + "\n");
                            this.addEditForHit(hit, file, edit2);
                        } else {
                            edit2 = new InsertEditParameters(this, defineStartOffset, DEFINE + " " + defineName, "", "\n");
                            this.addEditForHit(hit, file, edit2);
                        }
                        this.checkEndif(file, document, hit, defineStartOffset, defineName);
                        continue;
                    }
                    this.addGuardWrap(file, document, hit, startOffset, defineName);
                    continue;
                }
                this.addGuardWrap(file, document, hit, startOffset, defineName);
            }
            catch (BadLocationException | BadPartitioningException throwable) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
            }
        }
    }

    private void addGuardWrap(IFile file, IDocument document, OVMComplianceCheckHit hit, int startOffset, String defineName) {
        StringBuilder textToInsert = new StringBuilder().append(IFNDEF).append(" ").append(defineName).append("\n").append(DEFINE).append(" ").append(defineName);
        InsertEditParameters edit = new InsertEditParameters(this, startOffset, textToInsert.toString(), "", "\n");
        this.addEditForHit(hit, file, edit);
        InsertEditParameters edit2 = new InsertEditParameters(this, document.getLength(), "`endif " + this.getEndIfComment(this.endIfComment, defineName), "\n", "");
        this.addEditForHit(hit, file, edit2);
    }

    private void checkEndif(IFile file, IDocument document, OVMComplianceCheckHit hit, int startOffset, String defineName) throws BadLocationException {
        int counter = 1;
        Object[] token = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, startOffset, true);
        while (token != null && token[1] != null) {
            if (IFNDEF.equals(token[1]) || IFDEF.equals(token[1])) {
                ++counter;
            } else if (ENDIF.equals(token[1])) {
                --counter;
            }
            if (counter == 0) break;
            startOffset = (Integer)token[0] + ((String)token[1]).length();
            token = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, startOffset, true);
        }
        if (token == null || token[1] == null) {
            InsertEditParameters edit2 = new InsertEditParameters(this, document.getLength(), "`endif " + this.getEndIfComment(this.endIfComment, defineName), "\n", "");
            this.addEditForHit(hit, file, edit2);
        } else {
            int endifOffset = (Integer)token[0] + ((String)token[1]).length();
            int firstCharOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, endifOffset);
            if (firstCharOffset > -1 && firstCharOffset + 1 < document.getLength() && document.getChar(firstCharOffset) == '/' && document.getChar(firstCharOffset + 1) == '/') {
                int line = document.getLineOfOffset(firstCharOffset);
                int startOffsetLine = document.getLineOffset(line);
                int endOffsetLine = startOffsetLine + document.getLineLength(line);
                ReplaceEditParameters edit2 = new ReplaceEditParameters(this, firstCharOffset, endOffsetLine - firstCharOffset - 1, this.getEndIfComment(this.endIfComment, defineName));
                this.addEditForHit(hit, file, edit2);
            } else if (firstCharOffset == -1) {
                InsertEditParameters edit2 = new InsertEditParameters(this, endifOffset, " " + this.getEndIfComment(this.endIfComment, defineName), " ", "\n");
                this.addEditForHit(hit, file, edit2);
            } else {
                InsertEditParameters edit2 = new InsertEditParameters(this, firstCharOffset, this.getEndIfComment(this.endIfComment, defineName), " ", "\n");
                this.addEditForHit(hit, file, edit2);
            }
        }
    }

    private String getNameFromPattern(IDocument document, Pattern pattern, int lineOffset, int lineLength) {
        try {
            String lineContent = document.get(lineOffset, lineLength);
            Matcher matcher = pattern.matcher(lineContent);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String getEndIfComment(String endIfCommentStyle, String defineName) {
        StringBuilder endIfText = new StringBuilder("// ");
        if ("`ifndef define".equals(endIfCommentStyle)) {
            endIfText.append(IFNDEF).append(" ");
        }
        endIfText.append(defineName);
        return endIfText.toString();
    }
}

