/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class Autofix_SVTB_31_2_0
extends VerissimoAutofix {
    public Autofix_SVTB_31_2_0(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
            if (additionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object element = additionalInfo.getElement();
            if (!(element instanceof VlogMacroInfo)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            VlogMacroInfo macroInfo = (VlogMacroInfo)element;
            if (macroInfo.getReparseElement() != null) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("the failure is inside a macro definition");
                this.addError(error);
                continue;
            }
            int startOffset = macroInfo.getRealOffset();
            int endOffset = macroInfo.getEndRealOffset() + 1;
            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "`define", 0, startOffset, false);
            DeleteEditParameters edit = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
            this.addEditForHit(hit, file, edit);
        }
    }
}

