/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.parser.SVTBIssues;

public class Autofix_SVTB_31_3_0
extends VerissimoAutofix {
    private Map<RfFileDef, List<RfAbstractBlock>> allIfsAndCasesBlocksInFile = new HashMap<RfFileDef, List<RfAbstractBlock>>();

    public Autofix_SVTB_31_3_0(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    private boolean isInGenerateBlock(RfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof RfGenerateBlock) {
            return true;
        }
        return this.isInGenerateBlock(namedElement.getEnclosingScope());
    }

    private boolean isInAlwaysBlock(RfNamedElement namedElement) {
        if (!(namedElement instanceof RfActionBlock)) {
            return false;
        }
        return ((RfActionBlock)namedElement).isAlways();
    }

    private boolean checkIfDeleteIfAndCase(RfFileDef fileDef, RfAbstractBlock abstractBlock, int depthIndex) {
        if (depthIndex > 1 && (abstractBlock.isElsIf() || abstractBlock.isElse())) {
            return false;
        }
        List<RfAbstractBlock> ifsAndCases = this.allIfsAndCasesBlocksInFile.get(fileDef);
        int indexOfThisActionBlock = ifsAndCases.indexOf(abstractBlock);
        if (indexOfThisActionBlock + 1 >= ifsAndCases.size()) {
            return true;
        }
        RfAbstractBlock nextAbstractBlock = ifsAndCases.get(indexOfThisActionBlock + 1);
        if (abstractBlock.isIf() || abstractBlock.isElsIf()) {
            if ((nextAbstractBlock.isElsIf() || nextAbstractBlock.isElse()) && abstractBlock.getEnclosingScope().equals(nextAbstractBlock.getEnclosingScope())) {
                return false;
            }
        } else if (abstractBlock.isCaseItem() && nextAbstractBlock.isCaseItem()) {
            if (abstractBlock instanceof RfActionBlock && nextAbstractBlock instanceof RfActionBlock && abstractBlock.getEnclosingScope().equals(nextAbstractBlock.getEnclosingScope())) {
                return false;
            }
            if (abstractBlock instanceof RfGenerateBlock && nextAbstractBlock instanceof RfGenerateBlock && abstractBlock.getEnclosingScope().equals(nextAbstractBlock.getEnclosingScope()) && abstractBlock.getName().equals(nextAbstractBlock.getName())) {
                return false;
            }
        }
        return true;
    }

    private boolean isCheckedStatement(RfAbstractBlock abstractBlock) {
        boolean isActionBlockTypes = false;
        if (abstractBlock instanceof RfActionBlock) {
            boolean bl = isActionBlockTypes = ((RfActionBlock)abstractBlock).isLoop() || ((RfActionBlock)abstractBlock).isAlways();
        }
        return isActionBlockTypes || abstractBlock.isIf() || abstractBlock.isElsIf() || abstractBlock.isElse() || abstractBlock.isCaseItem() || abstractBlock.isCase();
    }

    private void collectIfsAndCases(RfFileDef fileDef, RfDefElement elem) {
        if (elem == null) {
            return;
        }
        Collection<RfDefElement> children = elem.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfDefElement child : children) {
            RfAbstractBlock abstractBlock;
            RfNamedElement enclosingScope;
            RfNamedElement namedElement;
            this.collectIfsAndCases(fileDef, child);
            if (!(child instanceof RfActionBlockDef) && !(child instanceof RfGenerateBlockDef) || !((namedElement = child.getNamedElement()) instanceof RfAbstractBlock) || (enclosingScope = (abstractBlock = (RfAbstractBlock)namedElement).getEnclosingScope()) instanceof RfConstraint || enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isWith() || !abstractBlock.isIf() && !abstractBlock.isElsIf() && !abstractBlock.isElse() && !abstractBlock.isCaseItem()) continue;
            this.allIfsAndCasesBlocksInFile.get(fileDef).add(abstractBlock);
        }
    }

    private boolean canDeleteFromCurrentBlock(RfAbstractBlock block) {
        if (block == null) {
            return true;
        }
        return !block.isElse() && !block.isElsIf();
    }

    private boolean canDeleteFromEnclosingBlock(RfAbstractBlock block) {
        return !block.hasBeginEnd() && !block.isCase();
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            char charAfterIssue;
            int depthIndex = 0;
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object element = autofixAdditionalInfo.getElement();
            if (element == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object defElement = autofixAdditionalInfo.getParentElement();
            if (defElement == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            SVTBIssues issue = (SVTBIssues)element;
            RfDefElement rfDefElement = (RfDefElement)defElement;
            if (!this.allIfsAndCasesBlocksInFile.containsKey(rfDefElement.getDefFile())) {
                this.allIfsAndCasesBlocksInFile.put(rfDefElement.getDefFile(), new LinkedList());
                this.collectIfsAndCases(rfDefElement.getDefFile(), rfDefElement.getDefFile());
                this.allIfsAndCasesBlocksInFile.get(rfDefElement.getDefFile()).sort((block1, block2) -> block1.getStartOffset() - block2.getStartOffset());
            }
            if (issue.getReparseInfo() != null) {
                VerissimoAutofixError autofixError = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                autofixError.setReason("empty statement is in macro definition");
                this.addError(autofixError);
                continue;
            }
            if (this.isInGenerateBlock(rfDefElement.getNamedElement())) {
                VerissimoAutofixError autofixError = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                autofixError.setReason("empty statement is in generate block");
                this.addError(autofixError);
                continue;
            }
            if (this.isInAlwaysBlock(rfDefElement.getNamedElement())) {
                VerissimoAutofixError autofixError = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                autofixError.setReason("empty statement is in always block");
                this.addError(autofixError);
                continue;
            }
            try {
                charAfterIssue = document.getChar(issue.getOffset());
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError(e.getMessage());
                continue;
            }
            int beginOffset = -1;
            int endOffset = -1;
            if (charAfterIssue == ';') {
                endOffset = issue.getOffset() + 1;
                if (!(rfDefElement.getNamedElement() instanceof RfAbstractBlock) || hit.getDetails().contains("Macro")) {
                    beginOffset = issue.getOffset();
                } else {
                    boolean cannotDeleteFlag = false;
                    prevBlock = null;
                    iterNamedElement = rfDefElement.getNamedElement();
                    do {
                        ++depthIndex;
                        RfAbstractBlock abstractBlock = (RfAbstractBlock)iterNamedElement;
                        if (abstractBlock.isSimpleBeginEnd() || abstractBlock.hasBeginEnd()) {
                            beginOffset = issue.getOffset();
                        } else {
                            if (!this.checkIfDeleteIfAndCase(rfDefElement.getDefFile(), abstractBlock, depthIndex)) {
                                cannotDeleteFlag = true;
                                break;
                            }
                            if (!this.canDeleteFromCurrentBlock(prevBlock)) break;
                            beginOffset = VerissimoAutofixEditsUtils.INSTANCE.getAbstractBlockLabelStartOffset(abstractBlock, document);
                            if (abstractBlock.getEnclosingScope() instanceof RfNamedActionBlock) {
                                labelName = ((RfNamedActionBlock)abstractBlock.getEnclosingScope()).getName();
                                beginOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, labelName, 0, beginOffset, false);
                            }
                            if (abstractBlock instanceof RfActionBlock && ((RfActionBlock)abstractBlock).isDoWhile()) {
                                endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", endOffset, document.getLength(), false);
                            }
                        }
                        prevBlock = abstractBlock;
                    } while ((iterNamedElement = iterNamedElement.getEnclosingScope()) instanceof RfAbstractBlock && this.canDeleteFromEnclosingBlock((RfAbstractBlock)iterNamedElement));
                    if (cannotDeleteFlag) {
                        autofixError = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                        autofixError.setReason("deleting said statement will affect the flow of the program");
                        this.addError(autofixError);
                        continue;
                    }
                }
            } else {
                if (!(rfDefElement.getNamedElement() instanceof RfAbstractBlock)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                boolean cannotDeleteFlag = false;
                prevBlock = null;
                iterNamedElement = rfDefElement.getNamedElement();
                do {
                    ++depthIndex;
                    RfAbstractBlock beginEndBlock = (RfAbstractBlock)iterNamedElement;
                    endOffset = beginEndBlock.getEndOffset();
                    if (this.isCheckedStatement(beginEndBlock)) {
                        if (!this.checkIfDeleteIfAndCase(rfDefElement.getDefFile(), beginEndBlock, depthIndex)) {
                            cannotDeleteFlag = true;
                            break;
                        }
                        if (!this.canDeleteFromCurrentBlock(prevBlock)) break;
                        beginOffset = VerissimoAutofixEditsUtils.INSTANCE.getAbstractBlockLabelStartOffset(beginEndBlock, document);
                        if (beginEndBlock.getEnclosingScope() instanceof RfNamedActionBlock) {
                            labelName = ((RfNamedActionBlock)beginEndBlock.getEnclosingScope()).getName();
                            beginOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, labelName, 0, beginOffset, false);
                        }
                        if (beginEndBlock instanceof RfActionBlock && ((RfActionBlock)beginEndBlock).isDoWhile()) {
                            endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", endOffset, document.getLength(), false);
                        }
                    } else if (rfDefElement.getNamedElement().getEnclosingScope() instanceof RfAbstractBlock) {
                        RfAbstractBlock enclosingAbstractBlock = (RfAbstractBlock)rfDefElement.getNamedElement().getEnclosingScope();
                        beginOffset = enclosingAbstractBlock.hasBeginEnd() ? VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "begin", 0, endOffset, false) : VerissimoAutofixEditsUtils.INSTANCE.getAbstractBlockLabelStartOffset(enclosingAbstractBlock, document);
                        if (enclosingAbstractBlock.getEnclosingScope() instanceof RfNamedActionBlock) {
                            String labelName = ((RfNamedActionBlock)enclosingAbstractBlock.getEnclosingScope()).getName();
                            beginOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, labelName, 0, beginOffset, false);
                        }
                    } else {
                        beginOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "begin", 0, endOffset, false);
                    }
                    prevBlock = beginEndBlock;
                } while ((iterNamedElement = iterNamedElement.getEnclosingScope()) instanceof RfAbstractBlock && this.canDeleteFromEnclosingBlock((RfAbstractBlock)iterNamedElement));
                if (cannotDeleteFlag) {
                    autofixError = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    autofixError.setReason("deleting said statement will affect the flow of the program");
                    this.addError(autofixError);
                    continue;
                }
            }
            DVTPair<Integer, Integer> offsetPair = VerissimoAutofixEditsUtils.INSTANCE.getStartAndEndOffsetGrabbingWhitespacesWithoutOverlap(beginOffset, endOffset, document);
            beginOffset = (Integer)offsetPair.getKey();
            endOffset = (Integer)offsetPair.getValue();
            this.addEditForHit(hit, file, new DeleteEditParameters(this, beginOffset, endOffset - beginOffset));
        }
    }
}

