/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.StringReplace;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroZone;

public class Autofix_SVTB_31_3_2
extends VerissimoAutofix {
    public Autofix_SVTB_31_3_2(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            try {
                RfProject rfProject = RfManager.getInstance().getRfProject(this.getIProject());
                RfWNamedElementAndScope elementAndScopeAtOffset = RfUtils.getRfElement(rfProject, file, document, document.getLineOffset(hit.getLine() - 1), null);
                if (elementAndScopeAtOffset == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                IRfScopeElement scope = elementAndScopeAtOffset.getScope();
                if (!(scope instanceof RfActionBlockDef)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if (!(((RfActionBlockDef)scope).getNamedElement() instanceof RfActionBlock)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                RfActionBlock actionBlock = (RfActionBlock)((RfActionBlockDef)scope).getNamedElement();
                RfActionBlock caseItem = null;
                if (actionBlock.isCase()) {
                    Collection<RfNamedElement> allCaseItems = actionBlock.getMembers();
                    if (allCaseItems == null || allCaseItems.isEmpty()) continue;
                    int lineOffset = document.getLineOffset(hit.getLine() - 1);
                    for (RfNamedElement currentCaseItem : allCaseItems) {
                        if (!(currentCaseItem instanceof RfActionBlock) || currentCaseItem.getDeclaration().getStartOffset() <= lineOffset) continue;
                        caseItem = (RfActionBlock)currentCaseItem;
                        break;
                    }
                } else if (actionBlock.isCaseItem()) {
                    caseItem = actionBlock;
                }
                if (caseItem == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                int startOffset = caseItem.getStartOffset();
                int endOffset = caseItem.getEndOffset();
                if ((startOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, startOffset - 1)) == -1) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if (document.getChar(startOffset) != ':') {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if ((startOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, startOffset - 1)) == -1) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                int caseItemEndOffset = startOffset + 1;
                if ((startOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfPreviousWhitespace(document, startOffset, true)) == -1) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                String actualExpression = document.get(startOffset + 1, caseItemEndOffset - startOffset - 1);
                if (!actualExpression.equals(caseItem.getExpression())) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("the case item uses a macro call");
                    this.addError(error);
                    continue;
                }
                String caseItemContent = document.get(startOffset, endOffset - startOffset);
                if (!caseItemContent.trim().endsWith(";") && !caseItemContent.trim().endsWith("end")) {
                    int macroCallStartOffset = endOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, endOffset);
                    int macroCallEndOffset = endOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextWhitespace(document, endOffset);
                    String macroName = document.get(macroCallStartOffset, macroCallEndOffset - macroCallStartOffset);
                    if (!macroName.startsWith("`")) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        continue;
                    }
                    macroName = macroName.substring(1);
                    VlogMacroZone macroZone = caseItem.getMacroZone();
                    if (macroZone == null) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        continue;
                    }
                    VlogMacroInfo macro = macroZone.getMacroInfo(macroName);
                    if (macro == null) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        continue;
                    }
                    List<StringReplace> macroReplacements = macro.getMacroText().getReplacement();
                    if (macroReplacements == null) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        continue;
                    }
                    boolean found = false;
                    for (StringReplace macroValue : macroReplacements) {
                        if (!macroValue.getString().trim().endsWith(";") && !macroValue.getString().trim().endsWith("end")) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        break;
                    }
                }
                DVTPair<Integer, Integer> offsetPair = VerissimoAutofixEditsUtils.INSTANCE.getStartAndEndOffsetGrabbingWhitespacesWithoutOverlap(startOffset, endOffset, document);
                startOffset = (Integer)offsetPair.getKey();
                endOffset = (Integer)offsetPair.getValue();
                DeleteEditParameters edit = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
                this.addEditForHit(hit, file, edit);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

