/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.StringReplace;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroZone;

public class Autofix_SVTB_31_3_3
extends VerissimoAutofix {
    public Autofix_SVTB_31_3_3(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            try {
                Object svtbIssue;
                VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
                if (additionalInfo == null || !((svtbIssue = additionalInfo.getElement()) instanceof SVTBIssues)) continue;
                RfProject rfProject = RfManager.getInstance().getRfProject(this.getIProject());
                RfWNamedElementAndScope elementAndScopeAtOffset = RfUtils.getRfElement(rfProject, file, document, ((SVTBIssues)svtbIssue).getOffset(), null);
                if (elementAndScopeAtOffset == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                IRfScopeElement scope = elementAndScopeAtOffset.getScope();
                RfActionBlock actionBlock = null;
                if (!(scope instanceof RfActionBlockDef)) {
                    RfNamedElement element = ((RfDefElement)scope).getNamedElement();
                    Collection<RfNamedElement> allMembers = element.getMembers();
                    int lineOffset = document.getLineOffset(hit.getLine() - 1);
                    for (RfNamedElement current : allMembers) {
                        if (!(current instanceof RfActionBlock)) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                            continue;
                        }
                        if (current.getDeclaration().getStartOffset() <= lineOffset) continue;
                        actionBlock = (RfActionBlock)current;
                        break;
                    }
                } else {
                    actionBlock = (RfActionBlock)((RfActionBlockDef)scope).getNamedElement();
                    if (!actionBlock.isLoop()) {
                        while (actionBlock.getEnclosingScope() instanceof RfActionBlock && ((RfActionBlock)actionBlock.getEnclosingScope()).isLoop()) {
                            actionBlock = (RfActionBlock)actionBlock.getEnclosingScope();
                        }
                    }
                }
                if (actionBlock == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if (this.hasMembersDeclaredOutsideLoop(hit, svtbIssue, actionBlock)) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("it changes variables declared outside loop statement.");
                    this.addError(error);
                    continue;
                }
                int startOffset = actionBlock.getStartOffset();
                int endOffset = actionBlock.getEndOffset();
                String content = document.get(startOffset, endOffset - startOffset);
                startOffset = VerissimoAutofixEditsUtils.INSTANCE.getActionBlockLabelStartOffset(actionBlock, document);
                if (!content.trim().endsWith(";") && !content.trim().endsWith("end")) {
                    int macroCallStartOffset = endOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, endOffset);
                    content = document.get(startOffset, (endOffset = VerissimoAutofixEditsUtils.INSTANCE.getOffsetOfNextWhitespace(document, endOffset)) - startOffset);
                    if (!content.trim().endsWith(";") && !content.trim().endsWith("end")) {
                        int macroCallEndOffset = endOffset;
                        String macroName = document.get(macroCallStartOffset, macroCallEndOffset - macroCallStartOffset);
                        if (!macroName.startsWith("`")) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                            continue;
                        }
                        macroName = macroName.substring(1);
                        VlogMacroZone macroZone = actionBlock.getMacroZone();
                        if (macroZone == null) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                            continue;
                        }
                        VlogMacroInfo macro = macroZone.getMacroInfo(macroName);
                        if (macro == null) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                            continue;
                        }
                        List<StringReplace> macroReplacements = macro.getMacroText().getReplacement();
                        if (macroReplacements == null) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                            continue;
                        }
                        boolean found = false;
                        for (StringReplace macroValue : macroReplacements) {
                            if (!macroValue.getString().trim().endsWith(";") && !macroValue.getString().trim().endsWith("end")) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                            continue;
                        }
                    }
                }
                DVTPair<Integer, Integer> offsetPair = VerissimoAutofixEditsUtils.INSTANCE.getStartAndEndOffsetGrabbingWhitespacesWithoutOverlap(startOffset, endOffset, document);
                startOffset = (Integer)offsetPair.getKey();
                endOffset = (Integer)offsetPair.getValue();
                DeleteEditParameters edit = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
                this.addEditForHit(hit, file, edit);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private boolean hasMembersDeclaredOutsideLoop(OVMComplianceCheckHit hit, Object svtbIssue, RfActionBlock actionBlock) {
        String loopKind = ((SVTBIssues)svtbIssue).getInfo();
        if (!IRfActionBlockElement.BlockQualifier.FOR.name().equals(loopKind)) {
            return false;
        }
        RfHidHolder hidHolder = actionBlock.getHidHolder();
        if (hidHolder == null) {
            return false;
        }
        Map hidObjectsMap = hidHolder.getHidObjectsMap();
        if (hidObjectsMap == null) {
            return false;
        }
        ListContainer hids = (ListContainer)hidObjectsMap.get(hit.getParserPath());
        if (hids == null) {
            return false;
        }
        for (IHidObject hid : hids) {
            List methodCalls;
            if (hid instanceof RfHidOperator) {
                IRfDefElement elementDeclaration;
                IRfNamedElement namedElement;
                IHidObject lhHid;
                RfHidOperator hidOperator = (RfHidOperator)hid;
                if (!hidOperator.isAssignment() && !hidOperator.isArithmeticAssignment() && !hidOperator.isLogicalAssignment() && !hidOperator.isIncrementOrDecrement() || !((lhHid = hidOperator.getLHValue()) instanceof RfHid) || !((namedElement = ((RfHid)lhHid).getElement()) instanceof RfNamedElement) || (elementDeclaration = namedElement.getDeclaration()) == null || elementDeclaration.getEndOffset() >= actionBlock.getStartOffset()) continue;
                return true;
            }
            if (!(hid instanceof IHid) || (methodCalls = MethodCallUtils.getMethodCalls((IHid)((IHid)hid))) == null || methodCalls.isEmpty()) continue;
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMap == null || methodCall.argumentValuesMap.isEmpty()) {
                    return false;
                }
                Set entrySet = methodCall.argumentValuesMap.entrySet();
                if (entrySet == null || entrySet.isEmpty()) {
                    return false;
                }
                for (Map.Entry argumentValue : entrySet) {
                    boolean isWriteOnly;
                    IRfNamedElement key = (IRfNamedElement)argumentValue.getKey();
                    if (!(key instanceof RfField)) continue;
                    RfField argument = (RfField)key;
                    Set values = (Set)argumentValue.getValue();
                    if (values == null || values.isEmpty()) continue;
                    boolean bl = isWriteOnly = this.isWrittenOnly(argument) || argument.isInout();
                    if (!isWriteOnly) continue;
                    boolean declaredOutside = false;
                    for (IHid value : values) {
                        IRfDefElement elementDeclaration;
                        IRfNamedElement namedElement;
                        if (!(value instanceof RfHid) || !((namedElement = ((RfHid)value).getElement()) instanceof RfNamedElement) || (elementDeclaration = namedElement.getDeclaration()) == null || elementDeclaration.getEndOffset() >= actionBlock.getStartOffset()) continue;
                        declaredOutside = true;
                    }
                    if (!isWriteOnly || !declaredOutside) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isWrittenOnly(RfField argument) {
        return argument.isOutput() || argument.isRef() && !argument.isConstRef();
    }
}

