/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public class Autofix_SVTB_32_4
extends VerissimoAutofix {
    public Autofix_SVTB_32_4(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        block8: for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object element = autofixAdditionalInfo.getElement();
            if (!(element instanceof List)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            List list = (List)element;
            if (list.isEmpty()) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            String indentOfCase = "";
            RfNamedElement previousActionBlock = null;
            RfActionBlock firstBlock = (RfActionBlock)list.get(0);
            RfActionBlock lastBlock = (RfActionBlock)list.get(list.size() - 1);
            int firstLine = -1;
            int firstLineOffset = -1;
            int endOffset = -1;
            try {
                firstLine = document.getLineOfOffset(VerissimoAutofixEditsUtils.INSTANCE.getActionBlockLabelStartOffset(firstBlock, document));
                firstLineOffset = document.getLineOffset(firstLine);
                endOffset = document.getNumberOfLines() < lastBlock.getEndLine() + 1 ? document.getLength() : document.getLineOffset(lastBlock.getEndLine());
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (firstLine == -1 || firstLineOffset == -1 || endOffset == -1) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            indentOfCase = VerissimoAutofixEditsUtils.INSTANCE.getIndentOfLine(firstLine, document);
            this.addEditForHit(hit, file, new InsertEditParameters(this, firstLineOffset, "case(1)", indentOfCase, "\n"), true);
            this.addEditForHit(hit, file, new InsertEditParameters(this, endOffset, "endcase", indentOfCase, "\n"), true);
            for (Object object : list) {
                boolean actionBlocksOnSameLine;
                if (!(object instanceof RfActionBlock)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue block8;
                }
                RfActionBlock actionBlock = (RfActionBlock)object;
                int actionBlockLabelStartOffset = VerissimoAutofixEditsUtils.INSTANCE.getActionBlockLabelStartOffset(actionBlock, document);
                int leftParanthesisOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "(", actionBlockLabelStartOffset, document.getLength(), true);
                int rightParanthesisOffset = VerissimoAutofixEditsUtils.INSTANCE.getMatchingRightParenthesesOffset(document, leftParanthesisOffset - 1, document.getLength());
                int startLine = -1;
                int startLineOffset = -1;
                try {
                    startLine = document.getLineOfOffset(actionBlockLabelStartOffset);
                    startLineOffset = document.getLineOffset(startLine);
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                if (startLine == -1 || startLineOffset == -1) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                boolean bl = actionBlocksOnSameLine = previousActionBlock != null && previousActionBlock.getEndLine() == startLine + 1;
                if (actionBlock.isIf()) {
                    if (actionBlocksOnSameLine) {
                        this.addEditForHit(hit, file, new DeleteEditParameters(this, actionBlockLabelStartOffset, leftParanthesisOffset - actionBlockLabelStartOffset), true);
                    } else {
                        this.addEditForHit(hit, file, new ReplaceEditParameters(this, startLineOffset, leftParanthesisOffset - startLineOffset, "\t" + indentOfCase), true);
                    }
                    this.addEditForHit(hit, file, new ReplaceEditParameters(this, rightParanthesisOffset, 1, ":"), true);
                } else if (actionBlock.isElsIf()) {
                    if (actionBlocksOnSameLine && previousActionBlock != null) {
                        this.addEditForHit(hit, file, new DeleteEditParameters(this, actionBlockLabelStartOffset, leftParanthesisOffset - actionBlockLabelStartOffset), true);
                        this.addEditForHit(hit, file, new ReplaceEditParameters(this, previousActionBlock.getEndOffset(), 1, "\n\t" + indentOfCase), true);
                    } else {
                        this.addEditForHit(hit, file, new ReplaceEditParameters(this, startLineOffset, leftParanthesisOffset - startLineOffset, "\t" + indentOfCase), true);
                    }
                    this.addEditForHit(hit, file, new ReplaceEditParameters(this, rightParanthesisOffset, 1, ":"), true);
                    int offsetOfIf = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "if", actionBlockLabelStartOffset, document.getLength(), true);
                    int lineOfIf = -1;
                    try {
                        lineOfIf = document.getLineOfOffset(offsetOfIf);
                    }
                    catch (BadLocationException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    startLine = lineOfIf;
                } else if (actionBlock.isElse()) {
                    if (actionBlocksOnSameLine && previousActionBlock != null) {
                        this.addEditForHit(hit, file, new ReplaceEditParameters(this, previousActionBlock.getEndOffset(), 1, "\n\t" + indentOfCase), true);
                        this.addEditForHit(hit, file, new ReplaceEditParameters(this, actionBlockLabelStartOffset, 4, "else", "default:"), true);
                    } else {
                        this.addEditForHit(hit, file, new ReplaceEditParameters(this, startLineOffset, actionBlockLabelStartOffset - startLineOffset + 4, "\t" + indentOfCase + "default:"), true);
                    }
                }
                int i = startLine + 1;
                while (i < actionBlock.getEndLine()) {
                    try {
                        this.addEditForHit(hit, file, new InsertEditParameters(this, document.getLineOffset(i), "\t"), true);
                    }
                    catch (BadLocationException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    ++i;
                }
                previousActionBlock = actionBlock;
            }
        }
    }
}

