/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.parser.SVTBIssues;

public class Autofix_SVTB_4_1_4_1_1
extends VerissimoAutofix {
    public Autofix_SVTB_4_1_4_1_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            int offset = -1;
            if (!(autofixAdditionalInfo.getElement() instanceof SVTBIssues) && !(autofixAdditionalInfo.getElement() instanceof Integer)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (autofixAdditionalInfo.getElement() instanceof SVTBIssues) {
                SVTBIssues svtbIssue = (SVTBIssues)autofixAdditionalInfo.getElement();
                if (svtbIssue.getVirtualOffset() != 0) {
                    VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                    error.setReason("it is defined in macro");
                    this.addError(error);
                    continue;
                }
                offset = svtbIssue.getOffset();
            }
            if (autofixAdditionalInfo.getElement() instanceof Integer) {
                offset = (Integer)autofixAdditionalInfo.getElement();
            }
            int startOffset = -1;
            int endOffset = -1;
            Object[] previousTextToken = VerissimoAutofixEditsUtils.INSTANCE.getPreviousTextToken(document, offset, true);
            if (previousTextToken == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            startOffset = (Integer)previousTextToken[0] + ((String)previousTextToken[1]).length();
            Object[] nextTextToken = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, startOffset, true);
            if (nextTextToken == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            endOffset = (Integer)nextTextToken[0];
            if (startOffset == -1 || endOffset == -1) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            DeleteEditParameters edit = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
            this.addEditForHit(hit, file, edit);
        }
    }
}

