/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

public class Autofix_SVTB_5_11_2_1
extends VerissimoAutofix {
    Map<RfNamedElement, Map<String, Integer>> variableIndexInScopeMap = new HashMap<RfNamedElement, Map<String, Integer>>();

    public Autofix_SVTB_5_11_2_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (hitAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!(hitAdditionalInfo.getElement() instanceof RfHid)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfHid rfHid = (RfHid)((Object)hitAdditionalInfo.getElement());
            if (rfHid.getReparseInfo() != null) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("$cast is used in macro '" + rfHid.getReparseInfo().getLastReparseMacroName() + "'");
                this.addError(error);
                continue;
            }
            if (!(hitAdditionalInfo.getParentElement() instanceof DVTPair)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            DVTPair pair = (DVTPair)hitAdditionalInfo.getParentElement();
            boolean isCastToVoid = (Boolean)pair.getValue();
            RfNamedElement scope = (RfNamedElement)pair.getKey();
            while (scope instanceof RfActionBlock) {
                scope = scope.getEnclosingScope();
            }
            int declareVariableOffset = scope instanceof RfFunction ? scope.getImplementation().getStartOffset() : scope.getStartOffset();
            declareVariableOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", declareVariableOffset, document.getLength(), true);
            String beforeIndentation = String.valueOf(DVTDocumentUtils.getIndent((int)scope.getStartOffset(), (IDocument)document)) + "\t";
            String variableName = VerissimoAutofixEditsUtils.INSTANCE.getNewVariableNameInScope("cast_result", scope, this.variableIndexInScopeMap);
            InsertEditParameters edit = new InsertEditParameters(this, declareVariableOffset, "int " + variableName + ";", beforeIndentation, "\n");
            this.addEditForHit(hit, file, edit);
            InsertEditParameters edit2 = new InsertEditParameters(this, rfHid.getOffset(), String.valueOf(variableName) + " = ");
            this.addEditForHit(hit, file, edit2);
            if (!isCastToVoid) continue;
            int voidStartOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "void'", 0, rfHid.getOffset(), false);
            DeleteEditParameters edit3 = new DeleteEditParameters(this, voidStartOffset, rfHid.getOffset() - voidStartOffset);
            this.addEditForHit(hit, file, edit3);
            int voidEndOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", voidStartOffset, document.getLength(), false);
            int voidParanthesesEndOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, ")", 0, voidEndOffset, false);
            DeleteEditParameters edit4 = new DeleteEditParameters(this, voidParanthesesEndOffset, voidEndOffset - voidParanthesesEndOffset - 1);
            this.addEditForHit(hit, file, edit4);
        }
    }
}

