/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;

public class Autofix_SVTB_5_2_8
extends VerissimoAutofix {
    public Autofix_SVTB_5_2_8(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
            if (additionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object operator = additionalInfo.getElement();
            if (!(operator instanceof HidOperator)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            HidOperator hidOperator = (HidOperator)operator;
            if (hidOperator.hasQualifier(HidOperatorQualifier.IS_HIDDEN.value())) continue;
            IReparseInfo reparseInfo = hidOperator.getReparseInfo();
            if (reparseInfo != null) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("it is defined in macro '" + reparseInfo.getLastReparseMacroName() + "'");
                this.addError(error);
                continue;
            }
            String operatorText = hidOperator.getOperatorText();
            int startOffset = hidOperator.getOccurrence().getOffset();
            ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffset, operatorText.length(), String.valueOf(operatorText) + "=");
            this.addEditForHit(hit, file, edit);
        }
    }
}

