/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class Autofix_SVTB_7_12_3_1
extends VerissimoAutofix {
    public Autofix_SVTB_7_12_3_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (hitAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!(hitAdditionalInfo.getElement() instanceof RfNamedElement)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfNamedElement element = (RfNamedElement)hitAdditionalInfo.getElement();
            RfNamedElement scope = element.getEnclosingScope();
            if (!(hitAdditionalInfo.getParentElement() instanceof DataType)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            DataType dt = (DataType)hitAdditionalInfo.getParentElement();
            String dtString = dt.getType();
            List<RfField> declaredParams = LintUtils.getParamsFromDataType(dt, scope);
            if (declaredParams == null || declaredParams.isEmpty()) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfDefElement declaration = element.getDeclaration();
            int declarationOffset = declaration.getStartOffset();
            Object[] token = null;
            int editOffset = 0;
            boolean wrapInParanthesis = false;
            if (element instanceof RfInstance || element instanceof RfClass) {
                tempOffset = declarationOffset;
                do {
                    if (token == null) continue;
                    tempOffset = (Integer)token[0] + ((String)token[1]).length();
                } while ((token = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, tempOffset, true)) != null && !((String)token[1]).contains(";") && !((String)token[1]).contains(dtString));
                if (token == null || !((String)token[1]).contains(dtString)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
            } else {
                tempOffset = declarationOffset;
                do {
                    if (token == null) continue;
                    tempOffset = (Integer)token[0];
                } while ((token = VerissimoAutofixEditsUtils.INSTANCE.getPreviousTextToken(document, tempOffset, true)) != null && !((String)token[1]).contains(";") && !((String)token[1]).contains(dtString));
                if (token == null || ((String)token[1]).contains(";")) {
                    if (element instanceof RfField && ((RfField)element).isAssociativeArray()) {
                        token = null;
                        tempOffset = declarationOffset;
                        do {
                            if (token == null) continue;
                            tempOffset = (Integer)token[0] + ((String)token[1]).length();
                        } while ((token = VerissimoAutofixEditsUtils.INSTANCE.getNextTextToken(document, tempOffset, true)) != null && !((String)token[1]).contains(";") && !((String)token[1]).contains(dtString));
                        if (token == null || !((String)token[1]).contains(dtString)) {
                            this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                            continue;
                        }
                    } else {
                        this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                        continue;
                    }
                }
            }
            String tokenString = (String)token[1];
            Integer tokenOffset = (Integer)token[0] + tokenString.indexOf(dtString);
            int semiOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, ";", tokenOffset, document.getLength(), false);
            int openParenOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "(", tokenOffset, semiOffset, false);
            int poundOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "#", tokenOffset, semiOffset, false);
            if (poundOffset == -1 || poundOffset >= semiOffset) {
                wrapInParanthesis = true;
                editOffset = tokenOffset + dtString.length();
            } else {
                int closeParanOffset;
                if (openParenOffset == -1 || openParenOffset <= poundOffset || semiOffset <= openParenOffset) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                if ((closeParanOffset = VerissimoAutofixEditsUtils.INSTANCE.getMatchingRightParenthesesOffset(document, --openParenOffset, document.getLength())) == -1) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                editOffset = closeParanOffset;
            }
            DVTStringBuilder sb = new DVTStringBuilder();
            if (dt.getInnerClassesInfo() != null && !dt.getInnerClassesInfo().isEmpty()) {
                dt = dt.getInnerClassesInfo().get(dt.getInnerClassesInfo().size() - 1);
            }
            List<DataType> orderedParams = dt.getOrderedParamAssignments();
            Map<String, ArgInfo> namedParams = dt.getNamedParamAssignments();
            HashMap<String, String> paramSpecializationValues = new HashMap<String, String>();
            if (orderedParams != null || orderedParams == null && namedParams == null) {
                EditParameters edit;
                if (orderedParams == null || orderedParams.size() == 1 && orderedParams.get(0).getType() == null) {
                    orderedParams = new ArrayList<DataType>();
                }
                int paramIndex = 0;
                while (paramIndex < orderedParams.size()) {
                    DataType paramDT = orderedParams.get(paramIndex);
                    if (paramDT.getType() != null && !paramDT.getType().isEmpty()) {
                        paramSpecializationValues.put(declaredParams.get(paramIndex).getName(), paramDT.toString());
                    }
                    ++paramIndex;
                }
                paramIndex = 0;
                while (paramIndex < declaredParams.size()) {
                    if (!declaredParams.get(paramIndex).isLocalParameter()) {
                        String paramValue = this.computeParameterSpecializationValue(declaredParams.get(paramIndex), paramSpecializationValues);
                        if (paramValue == null) {
                            sb = null;
                            break;
                        }
                        sb.append(paramValue).append(", ");
                        paramSpecializationValues.put(declaredParams.get(paramIndex).getName(), paramValue);
                    }
                    ++paramIndex;
                }
                if (sb == null || sb.toString().isEmpty()) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                sb.deleteLastChar().deleteLastChar();
                if (wrapInParanthesis) {
                    sb.prepend("#(").append(")");
                    edit = new InsertEditParameters(this, editOffset, sb.toString());
                } else {
                    edit = new ReplaceEditParameters(this, openParenOffset + 1, editOffset - (openParenOffset + 1), sb.toString());
                }
                this.addEditForHit(hit, file, edit);
                continue;
            }
            boolean replaceAllArgs = false;
            if (namedParams == null || namedParams.isEmpty()) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            for (Map.Entry<String, ArgInfo> entry : namedParams.entrySet()) {
                DataType entryDt = entry.getValue().getDataType();
                if (entryDt == null) {
                    replaceAllArgs = true;
                    continue;
                }
                paramSpecializationValues.put(entry.getKey(), entryDt.toString());
            }
            if (!replaceAllArgs) {
                for (RfField declaredParam : declaredParams) {
                    if (declaredParam.isLocalParameter() || namedParams.get(declaredParam.getName()) != null) continue;
                    String paramValue = this.computeParameterSpecializationValue(declaredParam, paramSpecializationValues);
                    if (paramValue == null) {
                        sb = null;
                        break;
                    }
                    sb.append(".").append(declaredParam.getName()).append("(").append(paramValue).append("), ");
                }
                if (sb == null || sb.toString().isEmpty()) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                sb.deleteLastChar().deleteLastChar();
                sb.prepend(", ");
                InsertEditParameters edit = new InsertEditParameters(this, editOffset, sb.toString());
                this.addEditForHit(hit, file, edit);
                continue;
            }
            int leftOffset = VerissimoAutofixEditsUtils.INSTANCE.getMatchingLeftParenthesesOffset(document, editOffset, 0);
            if (leftOffset == -1) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            ++leftOffset;
            for (RfField declaredParam : declaredParams) {
                if (declaredParam.isLocalParameter()) continue;
                String paramValue = this.computeParameterSpecializationValue(declaredParam, paramSpecializationValues);
                if (paramValue == null) {
                    sb = null;
                    break;
                }
                sb.append(".").append(declaredParam.getName()).append("(").append(paramValue).append("), ");
            }
            if (sb == null || sb.toString().isEmpty()) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            sb.deleteLastChar().deleteLastChar();
            ReplaceEditParameters edit = new ReplaceEditParameters(this, leftOffset, editOffset - leftOffset, sb.toString());
            this.addEditForHit(hit, file, edit);
        }
    }

    protected String computeParameterSpecializationValue(RfField param, Map<String, String> paramSpecializationOverwrites) {
        if (paramSpecializationOverwrites.containsKey(param.getName())) {
            return paramSpecializationOverwrites.get(param.getName());
        }
        RfNamedElement scope = param.getEnclosingScope();
        Map<String, IHidObject> defValues = null;
        if (scope instanceof RfClass) {
            defValues = ((RfClass)scope).getElabConstantDefaultExpressions();
        } else if (scope instanceof RfInstanceHolder) {
            defValues = ((RfInstanceHolder)scope).getElabConstantDefaultExpressions();
        }
        if (defValues == null) {
            return null;
        }
        IHidObject defValue = defValues.get(param.getName());
        return this.resolveHidValue(param, paramSpecializationOverwrites, defValue);
    }

    private String resolveHidValue(RfField param, Map<String, String> specializationOverwrites, IHidObject hidValue) {
        if (hidValue == null) {
            return null;
        }
        if (hidValue instanceof RfHidImplicit) {
            if (((RfHidImplicit)hidValue).getReparseInfo() != null) {
                return "`" + ((RfHidImplicit)hidValue).getReparseInfo().getLastReparseMacroName();
            }
            return ((RfHidImplicit)hidValue).getName();
        }
        if (hidValue instanceof RfHidOperator || hidValue instanceof RfHidAccessArgs) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            String resultString = HidUtils.toNiceString((IHidObject)hidValue);
            this.computeSemanticReplacements(replacements, param, specializationOverwrites, hidValue);
            for (Map.Entry entry : replacements.entrySet()) {
                String replaceTarget = "(?<![\\w$])" + Pattern.quote((String)entry.getKey()) + "(?![\\w$])";
                String replaceValue = Matcher.quoteReplacement((String)entry.getValue());
                resultString = resultString.replaceAll(replaceTarget, replaceValue);
            }
            return resultString;
        }
        if (!(hidValue instanceof RfHid)) {
            return null;
        }
        IRfNamedElement element = ((RfHid)hidValue).getElement();
        if (!(element instanceof RfField)) {
            return HidUtils.toNiceString((IHidObject)hidValue);
        }
        RfField fieldValue = (RfField)((RfHid)hidValue).getElement();
        if (!fieldValue.getEnclosingScope().equals(param.getEnclosingScope())) {
            return fieldValue.getFullName();
        }
        if (specializationOverwrites.containsKey(fieldValue.getName())) {
            return specializationOverwrites.get(fieldValue.getName());
        }
        return fieldValue.getInitialValue(false);
    }

    private void computeSemanticReplacements(Map<String, String> replacements, RfField param, Map<String, String> specializationOverwrites, IHidObject hidValue) {
        if (hidValue instanceof RfHidOperator) {
            RfHidOperator operator = (RfHidOperator)hidValue;
            ListContainer listContainer = operator.getRHValues();
            this.computeSemanticReplacements(replacements, param, specializationOverwrites, operator.getLHValue());
            if (listContainer == null) {
                return;
            }
            for (IHidObject RHHid : listContainer) {
                this.computeSemanticReplacements(replacements, param, specializationOverwrites, RHHid);
            }
            return;
        }
        if (hidValue instanceof RfHidAccessArgs) {
            List<? extends IHidObject> args = ((RfHidAccessArgs)hidValue).getArgumentValues();
            for (IHidObject iHidObject : args) {
                this.computeSemanticReplacements(replacements, param, specializationOverwrites, iHidObject);
            }
            return;
        }
        if (!(hidValue instanceof RfHid)) {
            return;
        }
        String replacement = this.resolveHidValue(param, specializationOverwrites, hidValue);
        if (replacement == null) {
            return;
        }
        replacements.putIfAbsent(HidUtils.toNiceString((IHidObject)hidValue), replacement);
    }
}

