/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.parser.ReparseInfo;

public class Autofix_SVTB_7_13
extends VerissimoAutofix {
    public Autofix_SVTB_7_13(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            IFile editFile;
            int startOffset;
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object element = autofixAdditionalInfo.getElement();
            if (!(element instanceof RfFunction)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (((RfFunction)element).isObjectStatic()) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("a static function can't be declared virtual");
                this.addError(error);
                continue;
            }
            String startKeyword = ((RfFunction)element).isTask() ? "task" : "function";
            RfDefElement declaration = ((RfFunction)element).getDeclaration();
            if (declaration == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            ReparseInfo reparseInfo = declaration.getReparseInfo();
            if (reparseInfo != null) {
                String macroName = reparseInfo.getLastReparseMacroName();
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("it is defined in macro '" + macroName + "'");
                this.addError(error);
                continue;
            }
            RfDefElement functionPrototype = ((RfFunction)element).getPrototype();
            if (functionPrototype != null) {
                startOffset = functionPrototype.getStartOffset();
                editFile = VerissimoAutofixUtils.getInstance().getFile(this.getIProject(), functionPrototype.getParserPath());
            } else {
                RfDefElement functionImplementation = ((RfFunction)element).getImplementation();
                startOffset = functionImplementation.getStartOffset();
                editFile = VerissimoAutofixUtils.getInstance().getFile(this.getIProject(), functionImplementation.getParserPath());
            }
            IDocument editDocument = VerissimoAutofixUtils.getInstance().getDocument(editFile);
            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(editDocument, startKeyword, 0, startOffset, false);
            InsertEditParameters edit = new InsertEditParameters(this, startOffset, "virtual", "", " ");
            this.addEditForHit(hit, editFile, edit);
        }
    }
}

