/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.fixes.ClassConstructorPrivacy;
import ro.amiq.vlogdt.model.reflection.RfFunction;

public class Autofix_SVTB_7_1_2
extends VerissimoAutofix
implements ClassConstructorPrivacy {
    protected static final String LOCAL = "local";
    protected static final String PROTECTED = "protected";
    protected static final String EMPTY = "";
    protected static final String PUBLIC = "public";

    public Autofix_SVTB_7_1_2(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            EditParameters parameter = this.getEditParameterForHit(hit, document, this);
            if (parameter == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            this.addEditForHit(hit, file, parameter);
        }
    }

    @Override
    public String getOldPrivacy(RfFunction constructor) {
        if (constructor.isProtected()) {
            return PROTECTED;
        }
        if (constructor.isPrivate()) {
            return LOCAL;
        }
        return EMPTY;
    }

    @Override
    public String getNewPrivacy() {
        return EMPTY;
    }
}

