/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.fixes.ClassConstructorPrivacy;
import ro.amiq.vlogdt.linter.base.annotations.AutofixParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.model.reflection.RfFunction;

public class Autofix_SVTB_7_1_2_1
extends UserInputAutofix
implements ClassConstructorPrivacy {
    @AutofixParameter(defaultValue="public", description="One of the following options: 'public' or 'local'.", name="newPrivacy", allowedValues={"public", "local"}, guiPrompt="Replace protected access modifiers with:", type=CheckParameterType.STRING)
    public String newPrivacy;
    private static final Pattern protectedPattern = Pattern.compile("protected");

    public Autofix_SVTB_7_1_2_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            EditParameters parameter = this.getEditParameterForHit(hit, document, this);
            if (parameter == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            this.addEditForHit(hit, file, parameter);
        }
    }

    @Override
    public String getOldPrivacy(RfFunction constructor) {
        return "protected";
    }

    @Override
    public String getNewPrivacy() {
        return this.newPrivacy;
    }

    @Override
    public String computeReplacementString(ReplaceEditParameters replaceEdit) {
        return DVTStringUtil.replaceFirst((Pattern)protectedPattern, (CharSequence)replaceEdit.getInitial(), (String)this.getNewPrivacy());
    }
}

