/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;

public class Autofix_SVTB_7_1_4
extends VerissimoAutofix {
    public Autofix_SVTB_7_1_4(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        try {
            if (hits == null || hits.isEmpty()) {
                return;
            }
            for (OVMComplianceCheckHit hit : hits) {
                Object[] implementationEdits;
                Object[] prototypeEdits;
                VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
                if (autofixAdditionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object element = autofixAdditionalInfo.getElement();
                if (!(element instanceof RfNamedElement)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                RfNamedElement namedElement = (RfNamedElement)element;
                RfDefElement defElement = namedElement.getDeclaration();
                RfClass classScope = namedElement.getEnclosingScope(RfClass.class);
                if (defElement instanceof RfConstraintDef) {
                    prototypeEdits = VlogQuickAssistUtil.computeSplitConstraintPrototypeInfo(document, null, namedElement);
                    implementationEdits = VlogQuickAssistUtil.computeSplitConstraintImplementationInfo(document, null, classScope, namedElement, defElement);
                } else {
                    prototypeEdits = VlogQuickAssistUtil.computeSplitMethodPrototypeInfo(document, null, namedElement, defElement, ((RfFunction)namedElement).isTask(), true);
                    implementationEdits = VlogQuickAssistUtil.computeSplitMethodImplementationInfo(document, null, classScope, namedElement, defElement, true);
                }
                DeleteEditParameters deleteFunctionEdit = new DeleteEditParameters(this, (Integer)prototypeEdits[0], (Integer)prototypeEdits[1]);
                this.addEditForHit(hit, file, deleteFunctionEdit);
                InsertEditParameters insertPrototypeEdit = new InsertEditParameters(this, (Integer)prototypeEdits[0], (String)prototypeEdits[2]);
                this.addEditForHit(hit, file, insertPrototypeEdit);
                InsertEditParameters insertImplementationEdit = new InsertEditParameters(this, (Integer)implementationEdits[0], (String)implementationEdits[1]);
                IFile implementationFile = file;
                if (classScope.getDeclaration() != null && classScope.getDeclaration().getFileAdapter() instanceof IFile) {
                    implementationFile = (IFile)classScope.getDeclaration().getFileAdapter();
                }
                this.addEditForHit(hit, implementationFile, insertImplementationEdit);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

