/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.ExternFunctionsOrdering;

public class Autofix_SVTB_7_1_4_4
extends VerissimoAutofix {
    public Autofix_SVTB_7_1_4_4(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo hitAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (hitAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            if (!(hitAdditionalInfo.getElement() instanceof List)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            List externFunctions = (List)hitAdditionalInfo.getElement();
            List<ExternFunctionsOrdering.GeneralEdit> edits = ExternFunctionsOrdering.getEditsForClassFunctions(externFunctions, document);
            for (ExternFunctionsOrdering.GeneralEdit edit : edits) {
                if (edit instanceof ExternFunctionsOrdering.DeleteEdit) {
                    this.addEditForHit(hit, file, new DeleteEditParameters(this, ((ExternFunctionsOrdering.DeleteEdit)edit).getStartOffset(), ((ExternFunctionsOrdering.DeleteEdit)edit).getLength()));
                    continue;
                }
                if (!(edit instanceof ExternFunctionsOrdering.InsertEdit)) continue;
                this.addEditForHit(hit, file, new InsertEditParameters(this, ((ExternFunctionsOrdering.InsertEdit)edit).getStartOffset(), ((ExternFunctionsOrdering.InsertEdit)edit).getText()));
            }
        }
    }
}

