/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;

public class Autofix_SVTB_7_26
extends VerissimoAutofix {
    public Autofix_SVTB_7_26(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            Object[] nextCodeCharPair;
            String endKeyword;
            String startKeyword;
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object element = autofixAdditionalInfo.getElement();
            if (!(element instanceof RfFunction)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfFunction function = (RfFunction)element;
            RfDefElement implementation = function.getImplementation();
            RfDefElement prototype = function.getPrototype();
            if (!(implementation instanceof RfFunctionDef)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            int startOffset = implementation.getStartOffset();
            int endOffset = implementation.getEndOffset();
            if (function.isFunction() || function.isConstructor()) {
                startKeyword = "function";
                endKeyword = "endfunction";
            } else {
                if (!function.isTask()) continue;
                startKeyword = "task";
                endKeyword = "endtask";
            }
            int functionKeywordOffset = startOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, startKeyword, 0, startOffset - 1, false);
            if (!function.isExtern()) {
                String accessModifier;
                int backwardAccessModifierOffset;
                int backwardStaticOffset;
                int backwardVirtualOffset;
                if (function.hasVirtualQualifier() && (backwardVirtualOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "virtual", 0, functionKeywordOffset, false)) < startOffset) {
                    startOffset = backwardVirtualOffset;
                }
                if (function.hasObjectStaticQualifier() && (backwardStaticOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, "static", 0, functionKeywordOffset, false)) < startOffset) {
                    startOffset = backwardStaticOffset;
                }
                if ((function.isProtected() || function.isPrivate()) && (backwardAccessModifierOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, accessModifier = function.isProtected() ? "protected" : "local", 0, functionKeywordOffset, false)) < startOffset) {
                    startOffset = backwardAccessModifierOffset;
                }
            }
            if (((Character)(nextCodeCharPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)(endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, endKeyword, endOffset, document.getLength(), false)), (boolean)true, (String)"__vlog_partitioning"))[0]).charValue() == ':') {
                endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, function.getName(), endOffset, document.getLength(), false);
            }
            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getStartOffsetWithIndentationIfAloneOnLine(startOffset, document);
            endOffset = VerissimoAutofixEditsUtils.INSTANCE.grabWhitespacesUntilNonWhitespaceOrEndLine(endOffset, document);
            DeleteEditParameters edit = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
            this.addEditForHit(hit, file, edit);
            if (prototype == null) continue;
            IFile prototypeFile = VerissimoAutofixUtils.getInstance().getFile(this.getIProject(), prototype.getParserPath());
            IDocument prototypeDocument = VerissimoAutofixUtils.getInstance().getDocument(this.getIProject(), prototype.getParserPath());
            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(prototypeDocument, "extern", 0, prototype.getStartOffset(), false, false);
            endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(prototypeDocument, ";", prototype.getEndOffset(), prototypeDocument.getLength(), false);
            startOffset = VerissimoAutofixEditsUtils.INSTANCE.getStartOffsetWithIndentationIfAloneOnLine(startOffset, prototypeDocument);
            endOffset = VerissimoAutofixEditsUtils.INSTANCE.grabWhitespacesUntilNonWhitespaceOrEndLine(endOffset, prototypeDocument);
            DeleteEditParameters prototypeEdit = new DeleteEditParameters(this, startOffset, endOffset - startOffset);
            this.addEditForHit(hit, prototypeFile, prototypeEdit);
        }
    }
}

