/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class Autofix_XVM_2_1_15_1
extends VerissimoAutofix {
    public Autofix_XVM_2_1_15_1(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            List<? extends IHidObject> argumentValues;
            IHidObject replaceArgument;
            String name;
            Object argumentValue;
            IRfNamedElement el;
            VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
            if (additionalInfo == null) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object namedElement = additionalInfo.getElement();
            if (!(namedElement instanceof RfField)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            Object operator = additionalInfo.getParentElement();
            if (!(operator instanceof RfHidOperator)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            RfField field = (RfField)namedElement;
            IHidObject createCallFirstArgument = (IHidObject)((RfHidOperator)operator).getRHValues().get(0);
            if (HidUtils.isHidAccess((IHidObject)createCallFirstArgument) && RfListType.isDynamicArray((IRfScopeElement)((HidAccess)createCallFirstArgument).getAssociatedType())) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            MethodCall methodCall = null;
            if (createCallFirstArgument instanceof RfHidAccessArgs) {
                methodCall = ((RfHidAccessArgs)createCallFirstArgument).getMethodCall();
            }
            if (createCallFirstArgument instanceof RfHid && (el = ((RfHid)createCallFirstArgument).getElement()) instanceof RfFunction) {
                methodCall = MethodCallUtils.getMethodCall((IHidObject)createCallFirstArgument, (IRfNamedElement)el, null, null, (boolean)false, null);
            }
            if (methodCall == null || !(methodCall.method instanceof RfFunction)) {
                this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                continue;
            }
            IHidObject lhValue = ((RfHidOperator)operator).getLHValue();
            List<IHidObject> selects = this.computeSelectsForField(lhValue);
            if (this.addErrorForSelect(hit, field, selects)) continue;
            String replacementString = this.computeReplacementString(field, selects);
            if (methodCall.argumentValuesMap == null || methodCall.argumentValuesMap.isEmpty()) {
                int startOffset = methodCall.getOccurrence().getOffset();
                if ((startOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "(", startOffset, ((RfHidOperator)operator).getCloseBoundary(), true)) >= ((RfHidOperator)operator).getCloseBoundary()) continue;
                InsertEditParameters edit = new InsertEditParameters(this, startOffset, replacementString);
                this.addEditForHit(hit, file, edit);
                continue;
            }
            RfField createCallNameArgument = ((RfFunction)methodCall.method).getArgumentWithPrefix("name", 1);
            IHidObject rawActualValue = (IHidObject)methodCall.argumentValuesMapRaw.get(createCallNameArgument);
            if (rawActualValue instanceof RfHid) {
                int endOffset;
                if (this.checkReparseInfo(((RfHid)rawActualValue).getReparseInfo(), hit)) continue;
                argumentValue = (RfHid)rawActualValue;
                name = argumentValue.getName();
                int startOffset = -1;
                if (argumentValue.getParentAccess() != null) {
                    HidAccess parentAccess = argumentValue.getParentAccess();
                    RfHid parentHid = (RfHid)parentAccess.getParentHid();
                    while (parentHid.getParentAccess() != null) {
                        parentAccess = parentHid.getParentAccess();
                        parentHid = (RfHid)parentAccess.getParentHid();
                    }
                    HidOccurrence parentOccurence = parentHid.getOccurrence();
                    startOffset = parentOccurence.getOffset();
                }
                HidOccurrence occurence = argumentValue.getOccurrence();
                if (startOffset == -1) {
                    startOffset = occurence.getOffset();
                    endOffset = name.length();
                } else {
                    endOffset = occurence.getOffset() - startOffset + name.length();
                }
                ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffset, endOffset, replacementString);
                this.addEditForHit(hit, file, edit);
                continue;
            }
            if (rawActualValue instanceof RfHidOperator) {
                if (this.checkReparseInfo(((RfHidOperator)rawActualValue).getReparseInfo(), hit)) continue;
                argumentValue = (RfHidOperator)rawActualValue;
                int startOffset = argumentValue.getOpenBoundary();
                int endOffset = argumentValue.getCloseBoundary();
                ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffset, endOffset - startOffset, replacementString);
                this.addEditForHit(hit, file, edit);
                continue;
            }
            if (rawActualValue instanceof RfHidAccessArgs) {
                Hid parentHid = ((RfHidAccessArgs)rawActualValue).getParentHid();
                if (!(parentHid instanceof RfHid) || this.checkReparseInfo(((RfHid)parentHid).getReparseInfo(), hit)) continue;
                int startOffset = -1;
                if (parentHid.getParentAccess() != null) {
                    while (parentHid.getParentAccess() != null) {
                        HidAccess parentAccess = parentHid.getParentAccess();
                        parentHid = parentAccess.getParentHid();
                    }
                    HidOccurrence parentOccurence = parentHid.getOccurrence();
                    startOffset = parentOccurence.getOffset();
                }
                if (startOffset == -1) {
                    HidOccurrence occurence = parentHid.getOccurrence();
                    startOffset = occurence.getOffset();
                }
                int openParenOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "(", startOffset, ((RfHidOperator)operator).getCloseBoundary(), true);
                int closeParenOffset = VerissimoAutofixEditsUtils.INSTANCE.getMatchingRightParenthesesOffset(document, openParenOffset - 1, ((RfHidOperator)operator).getCloseBoundary());
                ReplaceEditParameters edit = new ReplaceEditParameters(this, startOffset, closeParenOffset - startOffset + 1, replacementString);
                this.addEditForHit(hit, file, edit);
                continue;
            }
            if (!(rawActualValue instanceof RfHidImplicit)) continue;
            if (((RfHidImplicit)rawActualValue).getLastReparseElement() != null) {
                String macroName = ((RfHidImplicit)rawActualValue).getLastReparseElement().getReparseMacroName();
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason("it is defined in macro '" + macroName + "'");
                this.addError(error);
                continue;
            }
            argumentValue = (RfHidImplicit)rawActualValue;
            name = argumentValue.getName();
            int index = this.computeIndexOfNameArgument(methodCall);
            if (!(createCallFirstArgument instanceof RfHidAccessArgs) || !((replaceArgument = (argumentValues = ((RfHidAccessArgs)createCallFirstArgument).getArgumentValues()).get(index)) instanceof RfHidOperator)) continue;
            HidOperatorOccurrence replaceOccurence = ((RfHidOperator)replaceArgument).getOccurrence();
            int replaceStartOffset = replaceOccurence.getOffset();
            ReplaceEditParameters edit = new ReplaceEditParameters(this, replaceStartOffset, name.length(), replacementString);
            this.addEditForHit(hit, file, edit);
        }
    }

    private boolean checkReparseInfo(IReparseInfo reparseInfo, OVMComplianceCheckHit hit) {
        if (reparseInfo != null) {
            String macroName = reparseInfo.getLastReparseMacroName();
            VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
            error.setReason("it is defined in macro '" + macroName + "'");
            this.addError(error);
            return true;
        }
        return false;
    }

    private int computeIndexOfNameArgument(MethodCall methodCall) {
        IRfDefElement functionDef = methodCall.method.getDeclaration();
        if (!(functionDef instanceof RfFunctionDef)) {
            return 0;
        }
        int index = 0;
        RfFunctionDef def = (RfFunctionDef)functionDef;
        List<ArgInfo> arguments = def.getArgumentInfos();
        for (ArgInfo argument : arguments) {
            if ("name".equalsIgnoreCase(argument.getName())) break;
            ++index;
        }
        return index;
    }

    private boolean addErrorForSelect(OVMComplianceCheckHit hit, RfField field, List<IHidObject> selects) {
        for (IHidObject select : selects) {
            if (select instanceof RfHidImplicit) continue;
            VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
            error.setReason("the field name(" + field.getName() + (select instanceof RfHid ? "[" + ((RfHid)select).getName() + "]" : "") + ") depends on the array index");
            this.addError(error);
            return true;
        }
        return false;
    }

    private String computeReplacementString(RfField field, List<IHidObject> selects) {
        StringBuilder fieldName = new StringBuilder(field.getName());
        for (IHidObject select : selects) {
            if (!(select instanceof RfHidImplicit)) continue;
            fieldName.append("[").append(((RfHidImplicit)select).getName()).append("]");
        }
        return "\"" + fieldName.toString() + "\"";
    }

    private List<IHidObject> computeSelectsForField(IHidObject lhValue) {
        ArrayList<IHidObject> selects = new ArrayList();
        if (lhValue instanceof RfHidAccess) {
            selects = ((RfHidAccess)lhValue).getSelects();
        }
        if (lhValue instanceof RfHid && ((RfHid)lhValue).getAccesses() != null) {
            for (HidAccess access : ((RfHid)lhValue).getAccesses()) {
                List accessSelect = access.getSelects();
                if (accessSelect == null) continue;
                selects.addAll(accessSelect);
            }
        }
        return selects;
    }
}

