/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.parser.MacroCallItem;

public class Autofix_XVM_2_1_1_5
extends VerissimoAutofix {
    public Autofix_XVM_2_1_1_5(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        for (OVMComplianceCheckHit hit : hits) {
            try {
                List<RfField> parameters;
                VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
                if (additionalInfo == null) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object macroCallInfo = additionalInfo.getElement();
                if (!(macroCallInfo instanceof MacroCallItem)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                Object currentClass = additionalInfo.getParentElement();
                if (!(currentClass instanceof RfClass)) {
                    this.addError(new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE));
                    continue;
                }
                ArrayList<RfField> parametersInPortList = new ArrayList<RfField>();
                if (((RfClass)currentClass).hasPortListParameters() && (parameters = ((RfClass)currentClass).getLocalParameters(384)) != null && !parameters.isEmpty()) {
                    for (RfField parameter : parameters) {
                        if (!parameter.isInParameterPortList()) continue;
                        parametersInPortList.add(parameter);
                    }
                }
                String classFullName = ((RfClass)currentClass).getFullName();
                String className = ((RfClass)currentClass).getName();
                String firstParam = ((MacroCallItem)macroCallInfo).getMacroParameters()[0];
                int firstParamLength = firstParam.length();
                if (((RfClass)currentClass).hasPortListParameters() && firstParam.indexOf("#") != -1) {
                    firstParam = firstParam.substring(0, firstParam.indexOf("#")).trim();
                }
                int lineOffset = document.getLineOffset(hit.getLine() - 1);
                int endOffset = ((RfClass)currentClass).getEndOffset();
                int parameterOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, "(", lineOffset, endOffset, true);
                String replaceText = firstParam.contains("::") ? classFullName : className;
                if (!parametersInPortList.isEmpty()) {
                    replaceText = String.valueOf(replaceText) + "#(" + parametersInPortList.stream().map(e -> e.getName()).collect(Collectors.joining(", ")) + ")";
                }
                ReplaceEditParameters edit = new ReplaceEditParameters(this, parameterOffset, firstParamLength, replaceText);
                this.addEditForHit(hit, file, edit);
            }
            catch (BadLocationException e2) {
                DVTLogger.INSTANCE.logError((Throwable)e2);
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                this.addError(error);
            }
        }
    }
}

