/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.security.InvalidParameterException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_Names;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;

public class Autofix_XVM_5_3_5
extends Autofix_XVM_Names {
    protected String getPortSuffix;
    protected String getExportSuffix;
    protected String putPortSuffix;
    protected String putExportSuffix;
    protected String getPortParameterName;
    protected String getExportParameterName;
    protected String putPortParameterName;
    protected String putExportParameterName;

    public Autofix_XVM_5_3_5(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        this.getPortParameterName = "getPortSuffix";
        this.getExportParameterName = "getExportSuffix";
        this.putPortParameterName = "putPortSuffix";
        this.putExportParameterName = "putExportSuffix";
        this.computeFirstSuffix();
        for (OVMComplianceCheckHit hit : hits) {
            VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
            if (additionalInfo == null) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason(this.computeErrorReason(hit));
                this.addError(error);
                continue;
            }
            Object port = additionalInfo.getElement();
            if (!(port instanceof RfField)) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason(this.computeErrorReason(hit));
                this.addError(error);
                continue;
            }
            RfClass clazz = LintUtils.getFieldFinalClassTypeOrNull((RfField)port);
            if (clazz == null) {
                return;
            }
            String clazzName = clazz.getName();
            if (clazzName.endsWith("_get_port")) {
                this.replacementSuffix = this.getPortSuffix;
                this.parameterName = this.getPortParameterName;
            } else if (clazzName.endsWith("_get_export")) {
                this.replacementSuffix = this.getExportSuffix;
                this.parameterName = this.getExportParameterName;
            } else if (clazzName.endsWith("_put_port")) {
                this.replacementSuffix = this.putPortSuffix;
                this.parameterName = this.putPortParameterName;
            } else if (clazzName.endsWith("_put_export")) {
                this.replacementSuffix = this.putExportSuffix;
                this.parameterName = this.putExportParameterName;
            }
            VlogRenameRefactorInfo refactorInfo = this.computeRefactorInfoForHit(hit, file);
            if (refactorInfo == null || this.replacementSuffix == null) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason(this.computeErrorReason(hit));
                this.addError(error);
                continue;
            }
            refactorInfo.setNewName(this.getNewName(hit));
            this.rename(this, hit, refactorInfo);
        }
    }

    @Override
    protected void computeFirstSuffix() {
        String getPortSuffixesCSL = VerissimoAutofixUtils.getInstance().getParameterValueAsString(this.getCheck(), this.getPortParameterName);
        String getExportSuffixesCSL = VerissimoAutofixUtils.getInstance().getParameterValueAsString(this.getCheck(), this.getExportParameterName);
        String putPortSuffixesCSL = VerissimoAutofixUtils.getInstance().getParameterValueAsString(this.getCheck(), this.putPortParameterName);
        String putExportSuffixesCSL = VerissimoAutofixUtils.getInstance().getParameterValueAsString(this.getCheck(), this.putExportParameterName);
        this.getPortSuffix = this.computeFirstSuffixFromCSL(getPortSuffixesCSL);
        this.getExportSuffix = this.computeFirstSuffixFromCSL(getExportSuffixesCSL);
        this.putPortSuffix = this.computeFirstSuffixFromCSL(putPortSuffixesCSL);
        this.putExportSuffix = this.computeFirstSuffixFromCSL(putExportSuffixesCSL);
    }

    private String computeFirstSuffixFromCSL(String suffixesCSL) {
        if (suffixesCSL == null) {
            DVTLogger.INSTANCE.logError((Throwable)new InvalidParameterException("Cannot resolve suffix replacement!"));
            return null;
        }
        int firstComma = suffixesCSL.indexOf(44);
        return firstComma == -1 ? suffixesCSL : suffixesCSL.substring(0, firstComma);
    }
}

