/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import java.security.InvalidParameterException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.RenameAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixErrorType;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;

public class Autofix_XVM_Names
extends RenameAutofix {
    protected String replacementSuffix;
    protected String parameterName;

    public Autofix_XVM_Names(OVMComplianceCheck check, List<OVMComplianceCheckHit> hits) {
        super(check, hits);
    }

    @Override
    protected void getEditParametersForHits(List<OVMComplianceCheckHit> hits, IFile file, IDocument document) {
        if (hits == null || hits.isEmpty()) {
            return;
        }
        this.parameterName = "suffix";
        this.computeFirstSuffix();
        for (OVMComplianceCheckHit hit : hits) {
            VlogRenameRefactorInfo refactorInfo = this.computeRefactorInfoForHit(hit, file);
            if (refactorInfo == null || this.replacementSuffix == null) {
                VerissimoAutofixError error = new VerissimoAutofixError(hit, VerissimoAutofixErrorType.UNFIXABLE);
                error.setReason(this.computeErrorReason(hit));
                this.addError(error);
                continue;
            }
            refactorInfo.setNewName(this.getNewName(hit));
            this.rename(this, hit, refactorInfo);
        }
    }

    @Override
    public String getNewName(OVMComplianceCheckHit hit) {
        Object element = hit.getAutofixAdditionalInfo().getElement();
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        return String.valueOf(((RfNamedElement)element).getName()) + this.replacementSuffix;
    }

    @Override
    public IStatus checkIfValidName(String name) {
        if (name.endsWith(this.replacementSuffix)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "ro.amiq.vlogdt", "New name must have '" + this.replacementSuffix + "' suffix.");
    }

    protected void computeFirstSuffix() {
        String suffixesCSL = VerissimoAutofixUtils.getInstance().getParameterValueAsString(this.getCheck(), this.parameterName);
        if (suffixesCSL == null) {
            DVTLogger.INSTANCE.logError((Throwable)new InvalidParameterException("Cannot resolve suffix replacement!"));
            this.replacementSuffix = null;
            return;
        }
        int firstComma = suffixesCSL.indexOf(44);
        this.replacementSuffix = firstComma == -1 ? suffixesCSL : suffixesCSL.substring(0, firstComma);
    }

    protected String computeErrorReason(OVMComplianceCheckHit hit) {
        if (this.replacementSuffix == null) {
            return "cannot resolve a suffix from the '" + this.parameterName + "' parameter";
        }
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        ReparseInfo reparseInfo = ((RfNamedElement)element).getDeclaration().getReparseInfo();
        if (reparseInfo == null) {
            return null;
        }
        String macroName = reparseInfo.getLastReparseMacroName();
        return "it is defined in macro '" + macroName + "'";
    }
}

