/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.fixes;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixEditsUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroZone;

public interface ClassConstructorPrivacy {
    public static final String LOCAL = "local";
    public static final String PROTECTED = "protected";
    public static final String EMPTY = "";
    public static final String PUBLIC = "public";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public EditParameters getEditParameterForHit(OVMComplianceCheckHit hit, IDocument document, VerissimoAutofix autofix) {
        try {
            VerissimoAutofixAdditionalInfo autofixAdditionalInfo = hit.getAutofixAdditionalInfo();
            if (autofixAdditionalInfo == null) {
                return null;
            }
            Object element = autofixAdditionalInfo.getElement();
            if (!(element instanceof RfFunction)) {
                return null;
            }
            RfFunction constructor = (RfFunction)element;
            RfDefElement constructorDeclaration = constructor.getDeclaration();
            String oldPrivacy = this.getOldPrivacy(constructor);
            int startOffset = -1;
            int endOffset = -1;
            if (constructorDeclaration.getReparseInfo() == null) {
                int declarationOffset = constructorDeclaration.getStartOffset();
                startOffset = VerissimoAutofixEditsUtils.INSTANCE.getBackwardOffsetFor(document, oldPrivacy, 0, declarationOffset - 1, false, false);
                endOffset = startOffset + oldPrivacy.length();
            } else {
                String macroName = constructorDeclaration.getReparseInfo().getLastReparseMacroName();
                VlogMacroZone macroZone = constructor.getMacroZone();
                if (macroZone == null) {
                    return null;
                }
                VlogMacroInfo functionDeclMacro = macroZone.getMacroInfo(macroName);
                if (functionDeclMacro == null) {
                    return null;
                }
                endOffset = VerissimoAutofixEditsUtils.INSTANCE.getForwardOffsetFor(document, oldPrivacy, functionDeclMacro.getRealOffset(), document.getLength(), false);
                startOffset = endOffset - oldPrivacy.length();
            }
            if (startOffset >= -1 && endOffset != -1) {
                String text = document.get(startOffset, endOffset - startOffset);
                String replacement = text.replaceFirst(oldPrivacy, this.getNewPrivacy());
                return new ReplaceEditParameters(autofix, startOffset, endOffset - startOffset, text, replacement);
            }
            return null;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public String getOldPrivacy(RfFunction var1);

    public String getNewPrivacy();
}

