/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;

public class ExternFunctionsOrdering {
    public static List<GeneralEdit> getEditsForClassFunctions(List<FunctionData> externFunctions, IDocument document) {
        ArrayList<GeneralEdit> edits = new ArrayList<GeneralEdit>();
        int i = 0;
        while (i < externFunctions.size()) {
            int startOffset = ExternFunctionsOrdering.getFunctionImplementationStart(externFunctions.get(i).getImplementation(), document);
            int endOffset = ExternFunctionsOrdering.getFunctionImplementationEnd(externFunctions.get(i).getImplementation(), document);
            String funcText = "";
            try {
                funcText = document.get(startOffset, endOffset - startOffset);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
            externFunctions.get(i).setImplementationFunctionText(funcText);
            externFunctions.get(i).setImplementationRealStartOffset(startOffset);
            ++i;
        }
        for (FunctionData funcData : externFunctions) {
            edits.add(new DeleteEdit(funcData.getImplementationRealStartOffset(), funcData.getImplementationFunctionText().length()));
        }
        ArrayList<FunctionData> sortedExternFunctions = new ArrayList<FunctionData>(externFunctions);
        Collections.sort(sortedExternFunctions, (o1, o2) -> o1.getImplementationRealStartOffset() - o2.getImplementationRealStartOffset());
        int index = 0;
        while (index < externFunctions.size()) {
            edits.add(new InsertEdit(((FunctionData)sortedExternFunctions.get(index)).getImplementationRealStartOffset(), externFunctions.get(index).getImplementationFunctionText()));
            ++index;
        }
        return edits;
    }

    private static int getFunctionImplementationStart(RfDefElement implementation, IDocument document) {
        int startLine = implementation.getStartLine();
        if (implementation.getCommentBlock() != null && implementation.getCommentBlock().getAboveCommentStartLine() != -1) {
            startLine = implementation.getCommentBlock().getAboveCommentStartLine();
        }
        try {
            return document.getLineOffset(startLine - 1);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError(e.getMessage());
            return -1;
        }
    }

    private static int getFunctionImplementationEnd(RfDefElement implementation, IDocument document) {
        int endInitialOffset = implementation.getEndOffset();
        if (implementation.hasEndLabel()) {
            endInitialOffset = implementation.getEndLabelOffset();
        }
        try {
            int endLine = document.getLineOfOffset(endInitialOffset);
            return document.getLineOffset(endLine) + document.getLineLength(endLine);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError(e.getMessage());
            return -1;
        }
    }

    public static class DeleteEdit
    implements GeneralEdit {
        private int startOffset;
        private int length;

        public DeleteEdit(int startOffset, int length) {
            this.startOffset = startOffset;
            this.length = length;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static class FunctionData {
        private RfDefElement declaration;
        private RfDefElement implementation;
        private RfFunction function;
        private String implFuncText;
        private int implRealStartOffset;

        public FunctionData(RfFunctionDef first, RfFunctionDef second, RfFunction function) {
            if (first.isOutOfClassDefinition()) {
                this.implementation = first;
                this.declaration = second;
            } else {
                this.implementation = second;
                this.declaration = first;
            }
            this.function = function;
        }

        public RfDefElement getDeclaration() {
            return this.declaration;
        }

        public RfDefElement getImplementation() {
            return this.implementation;
        }

        public int getDeclarationStartOffset() {
            return this.declaration.getStartOffset();
        }

        public ParserPath getDeclarationFile() {
            return this.declaration.getParserPath();
        }

        public ParserPath getImplementationFile() {
            return this.implementation.getParserPath();
        }

        public int getDeclarationStartLine() {
            return this.declaration.getStartLine();
        }

        public int getImplementationStartLine() {
            return this.implementation.getStartLine();
        }

        public String getFullName() {
            return this.function.getFullName();
        }

        public void setImplementationFunctionText(String functionText) {
            this.implFuncText = functionText;
        }

        public String getImplementationFunctionText() {
            return this.implFuncText;
        }

        public void setImplementationRealStartOffset(int startOffset) {
            this.implRealStartOffset = startOffset;
        }

        public int getImplementationRealStartOffset() {
            return this.implRealStartOffset;
        }

        public int getImplementationStartOffset() {
            return this.implementation.getStartOffset();
        }
    }

    public static interface GeneralEdit {
    }

    public static class InsertEdit
    implements GeneralEdit {
        private int startOffset;
        private String text;

        public InsertEdit(int startOffset, String text) {
            this.startOffset = startOffset;
            this.text = text;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public String getText() {
            return this.text;
        }
    }
}

