/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.DeleteEditParameters;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.RenameAutofix;
import ro.amiq.vlogdt.linter.autofixes.ReplaceEditParameters;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public enum VerissimoAutofixEditsUtils {
    INSTANCE;


    public TextEdit getTextEdit(EditParameters editParameters) {
        if (editParameters instanceof DeleteEditParameters) {
            return new DeleteEdit(editParameters.getStartOffset(), ((DeleteEditParameters)editParameters).getLength());
        }
        VerissimoAutofix autofix = editParameters.getAutofix();
        if (editParameters instanceof InsertEditParameters) {
            InsertEditParameters insertEdit = (InsertEditParameters)editParameters;
            if (autofix instanceof UserInputAutofix) {
                insertEdit.setInsertedString(((UserInputAutofix)autofix).computeReplacementString(insertEdit));
            }
            String text = String.valueOf(insertEdit.getIndentationBefore()) + insertEdit.getInsertedString() + insertEdit.getIndentationAfter();
            return new InsertEdit(insertEdit.getStartOffset(), text);
        }
        if (editParameters instanceof ReplaceEditParameters) {
            ReplaceEditParameters replaceEdit = (ReplaceEditParameters)editParameters;
            if (autofix instanceof UserInputAutofix) {
                replaceEdit.setReplacement(((UserInputAutofix)autofix).computeReplacementString(replaceEdit));
            } else if (autofix instanceof RenameAutofix) {
                replaceEdit.setReplacement(((RenameAutofix)autofix).computeReplacementString(replaceEdit));
            }
            return new ReplaceEdit(replaceEdit.getStartOffset(), replaceEdit.getLength(), replaceEdit.getReplacement());
        }
        return null;
    }

    public boolean checkIfidenticalEdits(TextEdit textEdit1, TextEdit textEdit2) {
        if (!textEdit1.getClass().equals(textEdit2.getClass())) {
            return false;
        }
        if (textEdit1.getOffset() != textEdit2.getOffset()) {
            return false;
        }
        if (textEdit1.getLength() != textEdit2.getLength()) {
            return false;
        }
        return !(textEdit1 instanceof ReplaceEdit) || ((ReplaceEdit)textEdit1).getText().equals(((ReplaceEdit)textEdit2).getText());
    }

    public TextEdit getConflictingTextEdit(TextEdit textEdit, List<TextEdit> editsInFile) {
        if (textEdit instanceof InsertEdit) {
            return null;
        }
        if (editsInFile == null || editsInFile.isEmpty()) {
            return null;
        }
        for (TextEdit edit : editsInFile) {
            int start1 = textEdit.getOffset();
            int end1 = textEdit.getOffset() + textEdit.getLength();
            int start2 = edit.getOffset();
            int end2 = edit.getOffset() + edit.getLength();
            if (start1 >= end2 || start2 >= end1) continue;
            return edit;
        }
        return null;
    }

    public boolean parseCodeAndAddEdits(VerissimoAutofix autofix, OVMComplianceCheckHit hit, IFile file, IDocument document, int startOffset, int endOffset) {
        boolean result = false;
        try {
            boolean isMultiLineComment = false;
            boolean insideEscapedIdentifier = false;
            boolean insideStringConstant = false;
            boolean isSingleLineComment = false;
            char previousChar = '\u0000';
            char currentChar = document.getChar(startOffset);
            while (startOffset + 1 < endOffset) {
                boolean isInsideCode;
                previousChar = currentChar;
                currentChar = document.getChar(++startOffset);
                boolean bl = isInsideCode = !isSingleLineComment && !isMultiLineComment && !insideEscapedIdentifier && !insideStringConstant;
                if (isInsideCode && autofix.isValidCondition(previousChar, currentChar)) {
                    autofix.addEdit(hit, file, startOffset);
                    result = true;
                    break;
                }
                if (isInsideCode && previousChar == '/' && currentChar == '*') {
                    isMultiLineComment = true;
                    continue;
                }
                if (isMultiLineComment && previousChar == '*' && currentChar == '/') {
                    isMultiLineComment = false;
                    continue;
                }
                if (isInsideCode && currentChar == '\\') {
                    insideEscapedIdentifier = true;
                    continue;
                }
                if (insideEscapedIdentifier && currentChar == ' ') {
                    insideEscapedIdentifier = false;
                    continue;
                }
                if (isInsideCode && currentChar == '\"') {
                    insideStringConstant = true;
                    continue;
                }
                if (insideStringConstant && previousChar != '\\' && currentChar == '\"') {
                    insideStringConstant = false;
                    continue;
                }
                if (isInsideCode && previousChar == '/' && currentChar == '/') {
                    isSingleLineComment = true;
                    continue;
                }
                if (!isSingleLineComment || currentChar != '\n') continue;
                isSingleLineComment = false;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public int getOffsetOfPreviousWhitespace(IDocument document, int offset) {
        return this.getOffsetOfPreviousWhitespace(document, offset, false);
    }

    public int getOffsetOfPreviousWhitespace(IDocument document, int offset, boolean onlyCodeSection) {
        return this.getOffsetOfFirstChar(document, offset, false, true, onlyCodeSection);
    }

    public int getOffsetOfPreviousNonWhitespaceCharacter(IDocument document, int offset) {
        return this.getOffsetOfPreviousNonWhitespaceCharacter(document, offset, false);
    }

    public int getOffsetOfPreviousNonWhitespaceCharacter(IDocument document, int offset, boolean onlyCodeSection) {
        return this.getOffsetOfFirstChar(document, offset, false, false, onlyCodeSection);
    }

    public int getOffsetOfPreviousNonWhitespaceCharacter(IDocument document, int offset, int minLimit) {
        return this.getOffsetOfFirstChar(document, offset, false, false, false, minLimit, document.getLength());
    }

    public Object[] getPreviousTextToken(IDocument document, int startOffset, boolean onlyCodeSection) {
        int firstCharOffset;
        int lastCharOffset;
        Object[] result;
        block5: {
            block4: {
                result = new Object[2];
                lastCharOffset = this.getOffsetOfPreviousNonWhitespaceCharacter(document, startOffset - 1, onlyCodeSection);
                if (lastCharOffset != -1) break block4;
                return null;
            }
            firstCharOffset = this.getOffsetOfPreviousWhitespace(document, lastCharOffset - 1, onlyCodeSection) + 1;
            if (firstCharOffset != -1) break block5;
            return null;
        }
        try {
            result[0] = firstCharOffset;
            result[1] = document.get(firstCharOffset, lastCharOffset - firstCharOffset + 1);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces) {
        return VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, text, minOffsetLimit, offset, grabWhiteSpaces);
    }

    public final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces, boolean grabEndOfLine) {
        return VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, text, minOffsetLimit, offset, grabWhiteSpaces, grabEndOfLine);
    }

    public final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces, boolean grabEndOfLine, boolean onlyCodeSection) {
        return VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, text, minOffsetLimit, offset, grabWhiteSpaces, grabEndOfLine, onlyCodeSection);
    }

    public int getOffsetOfNextWhitespace(IDocument document, int offset) {
        return this.getOffsetOfNextWhitespace(document, offset, false);
    }

    public int getOffsetOfNextWhitespace(IDocument document, int offset, boolean onlyCodeSection) {
        return this.getOffsetOfFirstChar(document, offset, true, true, onlyCodeSection);
    }

    public int getOffsetOfNextNonWhitespaceCharacter(IDocument document, int offset) {
        return this.getOffsetOfNextNonWhitespaceCharacter(document, offset, false);
    }

    public int getOffsetOfNextNonWhitespaceCharacter(IDocument document, int offset, boolean onlyCodeSection) {
        return this.getOffsetOfFirstChar(document, offset, true, false, onlyCodeSection);
    }

    private int getOffsetOfFirstChar(IDocument document, int offset, boolean forward, boolean searchForWhitespace, boolean onlyCodeSection) {
        return this.getOffsetOfFirstChar(document, offset, forward, searchForWhitespace, onlyCodeSection, 0, document.getLength());
    }

    private int getOffsetOfFirstChar(IDocument document, int offset, boolean forward, boolean searchForWhitespace, boolean onlyCodeSection, int minLimit, int maxLimit) {
        if (offset < 0 || offset >= document.getLength()) {
            return -1;
        }
        try {
            int increment = forward ? 1 : -1;
            while (offset >= minLimit && (offset + 1 < maxLimit || offset + 1 == maxLimit && increment == -1)) {
                String content;
                if (onlyCodeSection && !"__dftl_partition_content_type".equals(content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", offset, false))) {
                    offset += increment;
                    continue;
                }
                if (Character.isWhitespace(document.getChar(offset)) != !searchForWhitespace) break;
                offset += increment;
            }
            return Math.max(minLimit, Math.min(offset, maxLimit));
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return -1;
        }
    }

    public Object[] getNextTextToken(IDocument document, int startOffset, boolean onlyCodeSection) {
        int lastCharOffset;
        int firstCharOffset;
        Object[] result;
        block10: {
            block9: {
                block8: {
                    block7: {
                        result = new Object[2];
                        firstCharOffset = this.getOffsetOfNextNonWhitespaceCharacter(document, startOffset, onlyCodeSection);
                        if (firstCharOffset != -1) break block7;
                        return null;
                    }
                    lastCharOffset = this.getOffsetOfNextWhitespace(document, firstCharOffset + 1, onlyCodeSection);
                    if (lastCharOffset != -1) break block8;
                    return null;
                }
                if (firstCharOffset >= 0 && firstCharOffset < document.getLength()) break block9;
                return null;
            }
            if (lastCharOffset >= 0 && lastCharOffset < document.getLength()) break block10;
            return null;
        }
        try {
            if (lastCharOffset < document.getLength() && Character.isWhitespace(document.getChar(lastCharOffset))) {
                --lastCharOffset;
            }
            result[0] = firstCharOffset;
            result[1] = document.get(firstCharOffset, lastCharOffset - firstCharOffset + 1);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public int getForwardOffsetFor(IDocument document, String text, int offset, int maxOffsetLimit, boolean grabEndOfLine) {
        return VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, text, offset, maxOffsetLimit, grabEndOfLine);
    }

    public int getMatchingRightParenthesesOffset(IDocument document, int leftParanthesesOffset, int maxOffset) {
        int counter = 1;
        int currentOffset = 0;
        try {
            String text = document.get(leftParanthesesOffset + 1, maxOffset - leftParanthesesOffset - 1);
            while (counter > 0 && currentOffset < text.length()) {
                char c;
                String content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", leftParanthesesOffset + currentOffset + 1, false);
                if (!"__dftl_partition_content_type".equals(content)) {
                    ++currentOffset;
                    continue;
                }
                if ((c = text.charAt(currentOffset++)) == '(') {
                    ++counter;
                    continue;
                }
                if (c != ')') continue;
                --counter;
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        if (counter == 0) {
            return leftParanthesesOffset + currentOffset;
        }
        return -1;
    }

    public int getMatchingLeftParenthesesOffset(IDocument document, int rightParanthesesOffset, int minOffset) {
        int counter = 1;
        int currentOffset = -1;
        try {
            String text = document.get(minOffset, rightParanthesesOffset);
            currentOffset = text.length() - 1;
            while (currentOffset >= 0) {
                String content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", minOffset + currentOffset, false);
                if (!"__dftl_partition_content_type".equals(content)) {
                    --currentOffset;
                    continue;
                }
                char c = text.charAt(currentOffset);
                if (c == ')') {
                    ++counter;
                } else if (c == '(') {
                    --counter;
                }
                if (counter != 0) {
                    --currentOffset;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        if (counter == 0) {
            return minOffset + currentOffset;
        }
        return -1;
    }

    public int getStartOffset(IRfScopeElement element, IDocument document) {
        if (element == null) {
            return -1;
        }
        if (element instanceof RfDefElement) {
            element = ((RfDefElement)element).getNamedElement();
        }
        if (element instanceof RfNamedElement) {
            if (element instanceof RfActionBlock) {
                RfActionBlock actionBlock = (RfActionBlock)element;
                RfDefElement actionBlockDeclaration = actionBlock.getDeclaration();
                if (actionBlockDeclaration == null) {
                    return -1;
                }
                int startOffset = actionBlockDeclaration.getStartOffset();
                if (actionBlock.isFor() || actionBlock.isForEach()) {
                    startOffset = this.getForwardOffsetFor(document, "(", startOffset, document.getLength(), false) - 1;
                    startOffset = this.getMatchingRightParenthesesOffset(document, startOffset, document.getLength()) + 1;
                }
                return startOffset;
            }
            RfDefElement elementDeclaration = ((RfNamedElement)element).getDeclaration();
            if (element instanceof RfFunction) {
                elementDeclaration = ((RfFunction)element).getImplementation();
            }
            if (elementDeclaration == null) {
                return -1;
            }
            return elementDeclaration.getStartOffset();
        }
        return -1;
    }

    public int getContentStartOffsetInsideScope(IRfScopeElement scope, IDocument document) {
        return this.getContentStartOffsetInsideScope(scope, document.getLength(), document);
    }

    public int getContentStartOffsetInsideScope(IRfScopeElement scope, int maxOffset, IDocument document) {
        int startOffset;
        if (scope instanceof RfDefElement) {
            scope = ((RfDefElement)scope).getNamedElement();
        }
        if ((startOffset = this.getStartOffset(scope, document)) < 0) {
            return -1;
        }
        if (scope instanceof RfNamedElement) {
            if (scope instanceof RfActionBlock) {
                if (((RfActionBlock)scope).hasBeginEnd()) {
                    Object[] previousToken = this.getPreviousTextToken(document, startOffset, true);
                    if (previousToken == null || previousToken.length < 2) {
                        return -1;
                    }
                    int beginOffset = 0;
                    if (!(previousToken != null && previousToken[1].equals("begin") || (beginOffset = this.getForwardOffsetFor(document, "begin", startOffset, maxOffset, false)) >= maxOffset)) {
                        startOffset = beginOffset;
                    }
                }
            } else {
                startOffset = this.getForwardOffsetFor(document, ";", startOffset, document.getLength(), false);
            }
        }
        return startOffset;
    }

    /*
     * Exception decompiling
     */
    public int getStartOffsetOfNextStatement(IDocument document, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getAbstractBlockLabelStartOffset(RfAbstractBlock abstractBlock, IDocument document) {
        if (abstractBlock instanceof RfActionBlock) {
            return this.getActionBlockLabelStartOffset((RfActionBlock)abstractBlock, document);
        }
        if (abstractBlock == null) {
            return -1;
        }
        int startOffset = abstractBlock.getStartOffset();
        if (abstractBlock.isCase()) {
            return INSTANCE.getBackwardOffsetFor(document, "case", 0, startOffset, false);
        }
        if (abstractBlock.isRandCase()) {
            return INSTANCE.getBackwardOffsetFor(document, "randcase", 0, startOffset, false);
        }
        if (abstractBlock.isCaseItem() && !abstractBlock.getExpression().contains("default")) {
            return INSTANCE.getBackwardOffsetFor(document, abstractBlock.getExpression().substring(abstractBlock.getExpression().indexOf("==") + 2).trim(), 0, startOffset, false);
        }
        return startOffset;
    }

    public int getActionBlockLabelStartOffset(RfActionBlock actionBlock, IDocument document) {
        if (actionBlock == null) {
            return -1;
        }
        int startOffset = actionBlock.getStartOffset();
        if (actionBlock.isIf()) {
            return INSTANCE.getBackwardOffsetFor(document, "if", 0, startOffset, false);
        }
        if (actionBlock.isElse() || actionBlock.isElsIf()) {
            return INSTANCE.getBackwardOffsetFor(document, "else", 0, startOffset, false);
        }
        if (actionBlock.isWhile()) {
            return INSTANCE.getBackwardOffsetFor(document, "while", 0, startOffset, false);
        }
        if (actionBlock.isForever()) {
            return INSTANCE.getBackwardOffsetFor(document, "forever", 0, startOffset, false);
        }
        if (actionBlock.isRepeat()) {
            return INSTANCE.getBackwardOffsetFor(document, "repeat", 0, startOffset, false);
        }
        if (actionBlock.isDoWhile()) {
            return INSTANCE.getBackwardOffsetFor(document, "do", 0, startOffset, false);
        }
        if (actionBlock.hasForkJoin()) {
            return INSTANCE.getBackwardOffsetFor(document, "fork", 0, startOffset, false);
        }
        if (actionBlock.isCase()) {
            return INSTANCE.getBackwardOffsetFor(document, "case", 0, startOffset, false);
        }
        if (actionBlock.isRandCase()) {
            return INSTANCE.getBackwardOffsetFor(document, "randcase", 0, startOffset, false);
        }
        if (actionBlock.isCaseItem()) {
            return INSTANCE.getBackwardOffsetFor(document, actionBlock.getExpression(), 0, startOffset, false);
        }
        return startOffset;
    }

    public int getStartOffsetWithIndentationIfAloneOnLine(int offset, IDocument document) {
        int previousNonWhitespaceOffset = this.getOffsetOfPreviousNonWhitespaceCharacter(document, offset - 1);
        previousNonWhitespaceOffset = previousNonWhitespaceOffset == 0 ? 0 : previousNonWhitespaceOffset + 1;
        int previousNewLineOffset = this.getBackwardOffsetFor(document, "\n", 0, offset, false);
        int n = previousNewLineOffset = previousNewLineOffset == 0 ? 0 : previousNewLineOffset + 1;
        if (previousNewLineOffset < previousNonWhitespaceOffset) {
            return offset;
        }
        return previousNewLineOffset;
    }

    public int grabWhitespacesUntilNonWhitespaceOrEndLine(int offset, IDocument document) {
        int nextNonWhitespaceOffset = this.getOffsetOfNextNonWhitespaceCharacter(document, offset);
        nextNonWhitespaceOffset = nextNonWhitespaceOffset == -1 ? document.getLength() : nextNonWhitespaceOffset;
        int nextNewLineOffset = offset == document.getLength() ? offset : this.getForwardOffsetFor(document, "\n", offset, document.getLength(), false);
        nextNewLineOffset = nextNewLineOffset == document.getLength() ? document.getLength() : nextNewLineOffset;
        return Math.min(nextNonWhitespaceOffset, nextNewLineOffset);
    }

    public DVTPair<Integer, Integer> getStartAndEndOffsetGrabbingWhitespacesWithoutOverlap(int startOffset, int endOffset, IDocument document) {
        int oldStartOffset = startOffset;
        startOffset = this.getStartOffsetWithIndentationIfAloneOnLine(startOffset, document);
        endOffset = this.grabWhitespacesUntilNonWhitespaceOrEndLine(endOffset, document);
        try {
            if (startOffset == oldStartOffset && document.getChar(endOffset - 1) == '\n') {
                --endOffset;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new DVTPair((Object)startOffset, (Object)endOffset);
    }

    /*
     * Exception decompiling
     */
    public int getEndOffsetOfPreviousStatement(RfProject rfProject, IFile file, IDocument document, int offset, boolean includeBlockEndingStatements) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getEndOffsetOfLastVariableDeclarationInScope(RfNamedElement scope, IDocument document) {
        Collection<RfNamedElement> allMembersInScope = scope.getMembers();
        if (allMembersInScope == null) {
            return this.getContentStartOffsetInsideScope(scope, document);
        }
        ArrayList<RfField> filteredElements = new ArrayList<RfField>(allMembersInScope.size());
        for (RfNamedElement rfNamedElement : allMembersInScope) {
            RfField field;
            if (!(rfNamedElement instanceof RfField) || rfNamedElement instanceof RfResultImplicitVariable || !(field = (RfField)rfNamedElement).isVariable() || field.isForLoopParameter()) continue;
            filteredElements.add(field);
        }
        if (filteredElements.isEmpty()) {
            return this.getContentStartOffsetInsideScope(scope, document);
        }
        Collections.sort(filteredElements, new Comparator<RfField>(){

            @Override
            public int compare(RfField field1, RfField field2) {
                return field2.getEndOffset() - field1.getEndOffset();
            }
        });
        return this.getStartOffsetOfNextStatement(document, ((RfField)filteredElements.get(0)).getEndOffset());
    }

    /*
     * Unable to fully structure code
     */
    public int getEndOffsetIfInlineComment(IDocument document, int offset, int line) {
        startOffset = offset;
        try {
            scanner = new DVTCharacterScanner(20, document, Math.max(0, startOffset), true);
            ch = 0;
            maxOffsetLimit = document.getLength();
            content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
            while (document.getLineOfOffset(scanner.getOffset()) == line && !content.equals("__vlog_ml_comment") && !content.equals("__vlog_sl_comment")) {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) break;
                content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), true);
            }
            if (content.equals("__vlog_ml_comment") || content.equals("__vlog_sl_comment")) ** GOTO lbl17
            return startOffset;
lbl-1000:
            // 1 sources

            {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) break;
                content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), true);
lbl17:
                // 2 sources

                ** while (content.equals((Object)"__vlog_ml_comment") || content.equals((Object)"__vlog_sl_comment"))
            }
lbl18:
            // 3 sources

            while (ch != 10) {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) break;
            }
            startOffset = scanner.getOffset();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return startOffset;
    }

    public String getIndent(int offset, IDocument document) {
        return DVTDocumentUtils.getIndent((int)offset, (IDocument)document);
    }

    public String getIndentOfLine(int line, IDocument document) {
        try {
            int startOffset = document.getLineOffset(line);
            int firstCodeChar = INSTANCE.getOffsetOfNextNonWhitespaceCharacter(document, startOffset, true);
            String initialIndent = document.get(startOffset, firstCodeChar - startOffset);
            if (initialIndent.trim().isEmpty()) {
                return initialIndent;
            }
            StringBuilder indent = new StringBuilder();
            int i = 0;
            while (i < initialIndent.length()) {
                char currentChar = initialIndent.charAt(i);
                if (currentChar == '\t') {
                    indent.append("\t");
                } else {
                    indent.append(" ");
                }
                ++i;
            }
            return indent.toString();
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public String getBlockIndentation(IDocument document, RfNamedElement actionBlock) {
        String previousIndent = this.getIndentOfLine(actionBlock.getDeclaration().getStartLine() - 1, document);
        RfNamedElement enclosingScope = actionBlock.getEnclosingScope();
        while (enclosingScope != null) {
            RfDefElement declaration = enclosingScope.getDeclaration();
            if (declaration == null) {
                return previousIndent;
            }
            int startLine = enclosingScope.getDeclaration().getStartLine();
            String indent = this.getIndentOfLine(startLine - 1, document);
            if (indent.isEmpty()) {
                return previousIndent;
            }
            previousIndent = indent;
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return previousIndent;
    }

    public List<EditParameters> insertBeginEndForActionBlock(RfNamedElement namedElement, IDocument document, VerissimoAutofix autofix) {
        if (!(namedElement instanceof RfActionBlock)) {
            return null;
        }
        RfActionBlock actionBlock = (RfActionBlock)namedElement;
        if (actionBlock.isSimpleBeginEnd() || actionBlock.hasBeginEnd()) {
            return null;
        }
        int startOffset = this.getStartOffset(namedElement, document);
        InsertEditParameters beginEdit = new InsertEditParameters(autofix, startOffset, "begin", " ", " ");
        beginEdit.setEditPriority(EditParameters.PRIORITY.BEGIN_ACTION_BLOCK);
        int endOffset = actionBlock.getDeclaration().getEndOffset();
        String lineIndent = DVTDocumentUtils.getIndent((int)startOffset, (IDocument)document);
        String beforeIndentation = "\n" + lineIndent;
        String afterIndentation = "";
        if (actionBlock.isDoWhile()) {
            endOffset = this.getBackwardOffsetFor(document, "while", 0, endOffset, false);
            beforeIndentation = "";
            afterIndentation = "\n" + lineIndent;
        }
        InsertEditParameters endEdit = new InsertEditParameters(autofix, endOffset, "end", beforeIndentation, afterIndentation);
        endEdit.setEditPriority(EditParameters.PRIORITY.END_ACTION_BLOCK);
        return Stream.of(beginEdit, endEdit).collect(Collectors.toList());
    }

    public List<EditParameters> insertBeginEndForGenerateBlock(RfNamedElement namedElement, IDocument document, VerissimoAutofix autofix) {
        if (!(namedElement instanceof RfGenerateBlock)) {
            return null;
        }
        RfGenerateBlock generateBlock = (RfGenerateBlock)namedElement;
        if (generateBlock.isSimpleBeginEnd() || generateBlock.hasBeginEnd()) {
            return null;
        }
        Collection<RfNamedElement> members = generateBlock.getMembers();
        if (members == null || members.isEmpty()) {
            return null;
        }
        int generateBlockStartOffset = generateBlock.getDeclaration().getStartOffset();
        int firstMemberStartOffset = members.iterator().next().getStartOffset();
        int endOffset = generateBlock.getDeclaration().getEndOffset();
        if (generateBlock.isIf()) {
            int firstCollonOffset = INSTANCE.getBackwardOffsetFor(document, ")", generateBlockStartOffset, firstMemberStartOffset, false);
            if (firstCollonOffset != generateBlockStartOffset) {
                firstMemberStartOffset = firstCollonOffset + 1;
            }
        } else {
            firstMemberStartOffset = generateBlock.isElse() ? INSTANCE.getForwardOffsetFor(document, "else", generateBlockStartOffset, endOffset, false) : generateBlockStartOffset + 1;
        }
        InsertEditParameters beginEdit = new InsertEditParameters(autofix, firstMemberStartOffset, "begin", " ", " ");
        beginEdit.setEditPriority(EditParameters.PRIORITY.BEGIN_ACTION_BLOCK);
        String lineIndent = DVTDocumentUtils.getIndent((int)firstMemberStartOffset, (IDocument)document);
        String beforeIndentation = "\n" + lineIndent;
        String afterIndentation = " ";
        InsertEditParameters endEdit = new InsertEditParameters(autofix, endOffset + 1, "end", beforeIndentation, afterIndentation);
        endEdit.setEditPriority(EditParameters.PRIORITY.END_ACTION_BLOCK);
        return Stream.of(beginEdit, endEdit).collect(Collectors.toList());
    }

    public List<EditParameters> placeBeginConsistently(VerissimoAutofix autofix, RfProject project, OVMComplianceCheckHit hit, IDocument document, int offset, int line, boolean mustBeOnSameLine) {
        if (mustBeOnSameLine) {
            int previousLineEndOffset = INSTANCE.getOffsetOfPreviousNonWhitespaceCharacter(document, offset - 1, true) + 1;
            RfFileDef fileDef = project.getFileDefUsingParserPath(hit.getParserPath());
            RfDefElement defScope = fileDef.getScope(offset, true);
            try {
                int previousLine = document.getLineOfOffset(previousLineEndOffset) + 1;
                CodePreprocFileInfo preprocInfo = project.getPreprocessingTable().getCodePreprocFileInfos().get(hit.getParserPath());
                if (preprocInfo != null && previousLine != defScope.getStartLine()) {
                    boolean foundPreprocInfoBetween = false;
                    int l = previousLine;
                    while (l < hit.getLine()) {
                        if (preprocInfo.getInfo(l) != null) {
                            foundPreprocInfoBetween = true;
                            break;
                        }
                        ++l;
                    }
                    if (foundPreprocInfoBetween) {
                        return null;
                    }
                }
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            DeleteEditParameters delete = new DeleteEditParameters(autofix, offset, 5);
            InsertEditParameters insert = new InsertEditParameters(autofix, previousLineEndOffset, " begin");
            return Stream.of(delete, insert).collect(Collectors.toList());
        }
        String lineIndentation = INSTANCE.getIndentOfLine(line, document);
        InsertEditParameters edit = new InsertEditParameters(autofix, offset, "\n" + lineIndentation);
        return Stream.of(edit).collect(Collectors.toList());
    }

    public String getNewVariableNameInScope(String baseVariableName, RfNamedElement scope, Map<RfNamedElement, Map<String, Integer>> variableIndexInScopeMap) {
        variableIndexInScopeMap.putIfAbsent(scope, new HashMap());
        variableIndexInScopeMap.get(scope).putIfAbsent(baseVariableName, 0);
        int newIndex = variableIndexInScopeMap.get(scope).get(baseVariableName) + 1;
        variableIndexInScopeMap.get(scope).put(baseVariableName, newIndex);
        String variableName = newIndex == 1 ? baseVariableName : String.valueOf(baseVariableName) + newIndex;
        Collection<RfNamedElement> membersInScope = scope.getMembers();
        HashSet<String> membersNames = new HashSet<String>();
        if (membersInScope != null) {
            for (RfNamedElement element : membersInScope) {
                membersNames.add(element.getName());
            }
        }
        while (membersNames.contains(variableName)) {
            newIndex = variableIndexInScopeMap.get(scope).get(baseVariableName) + 1;
            variableIndexInScopeMap.get(scope).put(baseVariableName, newIndex);
            variableName = String.valueOf(baseVariableName) + newIndex;
        }
        return variableName;
    }
}

