/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.quick.proposals.QuickProposalPriorityByType;
import ro.amiq.dvt.ui.editor.quick.proposals.QuickProposalsWrapper;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixAnnotationPriority;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixAnnotationWrapper;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixProposal;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.linter.ui.VerissimoWaiveHitProposal;

public enum VerissimoAutofixQuickFixProposalsUtils {
    INSTANCE;

    public static final long BUSY_INDICATOR_TIMEOUT = 1500L;
    public static final int QUICK_FIX_TOOLTIP_TIMEOUT = 200;
    public static final String COMPUTING_AUTOFIX_PROPOSALS = "Computing autofix proposals...";

    public List<QuickFixAnnotationWrapper> collectLintingMarkers(int offset, IDocument document, int lineOfOffset, IAnnotationModel annotationModel) {
        ArrayList<QuickFixAnnotationWrapper> lintingMarkers = new ArrayList<QuickFixAnnotationWrapper>();
        Iterator iter = annotationModel.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof MarkerAnnotation)) continue;
            IMarker marker = ((MarkerAnnotation)annotation).getMarker();
            try {
                String type = marker.getType();
                if (!LintingProblemsManager.LINTING_MARKERS.contains(type)) continue;
                Position position = annotationModel.getPosition(annotation);
                int markerPositionOffset = position.getOffset();
                if (offset >= markerPositionOffset && offset <= markerPositionOffset + position.getLength()) {
                    lintingMarkers.add(new QuickFixAnnotationWrapper((MarkerAnnotation)annotation, QuickFixAnnotationPriority.CURSOR, markerPositionOffset));
                    continue;
                }
                if (lineOfOffset != document.getLineOfOffset(markerPositionOffset)) continue;
                lintingMarkers.add(new QuickFixAnnotationWrapper((MarkerAnnotation)annotation, QuickFixAnnotationPriority.LINE, markerPositionOffset));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return lintingMarkers;
    }

    public List<QuickProposalsWrapper> getAutofixProposalsFromMarkers(List<QuickFixAnnotationWrapper> lintingAnnotations) {
        ArrayList<QuickProposalsWrapper> autoFixProposals = new ArrayList<QuickProposalsWrapper>();
        if (lintingAnnotations == null || lintingAnnotations.isEmpty()) {
            return autoFixProposals;
        }
        for (QuickFixAnnotationWrapper lintingAnnotation : lintingAnnotations) {
            try {
                ICompletionProposal proposal;
                if (lintingAnnotation.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_CURSOR || lintingAnnotation.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_LINE || (proposal = this.getAutofixProposalFromMarker(lintingAnnotation.getAnnotation().getMarker(), true)) == null) continue;
                QuickProposalsWrapper quickFixWrapper = new QuickProposalsWrapper(proposal, QuickProposalPriorityByType.VERISSIMO_AUTOFIX, lintingAnnotation.getMarkerOffset());
                quickFixWrapper.setQuickFixAnnotationPriority(lintingAnnotation.getQuickFixProposalPriority());
                autoFixProposals.add(quickFixWrapper);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return autoFixProposals;
    }

    public List<QuickProposalsWrapper> getWaiveHitsProposalsFromMarkers(List<QuickFixAnnotationWrapper> lintingAnnotations) {
        ArrayList<QuickProposalsWrapper> waiveHitsProposals = new ArrayList<QuickProposalsWrapper>();
        if (lintingAnnotations == null || lintingAnnotations.isEmpty()) {
            return waiveHitsProposals;
        }
        for (QuickFixAnnotationWrapper lintingAnnotation : lintingAnnotations) {
            try {
                if (lintingAnnotation.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_CURSOR || lintingAnnotation.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_LINE) continue;
                ICompletionProposal proposal = this.getWaiveHitProposalFromMarker(lintingAnnotation.getAnnotation());
                if (proposal == null) {
                    return waiveHitsProposals;
                }
                QuickProposalsWrapper quickFixWrapper = new QuickProposalsWrapper(proposal, QuickProposalPriorityByType.CREATE_LINT_WAIVER, lintingAnnotation.getMarkerOffset());
                quickFixWrapper.setQuickFixAnnotationPriority(lintingAnnotation.getQuickFixProposalPriority());
                waiveHitsProposals.add(quickFixWrapper);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return waiveHitsProposals;
    }

    private ICompletionProposal getWaiveHitProposalFromMarker(MarkerAnnotation annotation) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.scheduleTimeoutWatchDog((IProgressMonitor)monitor, 200);
        ICompletionProposal proposalFromMarker = this.getLintingWaiveHitsProposalFromMarker(annotation.getMarker());
        return proposalFromMarker;
    }

    private ICompletionProposal getAutofixProposalFromMarker(final IMarker marker, boolean startMonitorJob) {
        final ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (startMonitorJob) {
            final AtomicBoolean done = new AtomicBoolean(false);
            Job computingQuickFixProposalJob = new Job("Compute Autofix Proposals Job"){

                protected IStatus run(IProgressMonitor monitor) {
                    ICompletionProposal proposalFromMarker = VerissimoAutofixQuickFixProposalsUtils.this.getLintingAutofixProposalFromMarker(marker);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    proposals.add(proposalFromMarker);
                    done.set(true);
                    return Status.OK_STATUS;
                }
            };
            computingQuickFixProposalJob.schedule();
            long busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
            DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingQuickFixProposalJob, (AtomicBoolean)done, (String)COMPUTING_AUTOFIX_PROPOSALS, (long)busyIndicatorTimeout);
        } else {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.scheduleTimeoutWatchDog((IProgressMonitor)monitor, 200);
            ICompletionProposal proposalFromMarker = this.getLintingAutofixProposalFromMarker(marker);
            proposals.add(proposalFromMarker);
        }
        if (proposals.isEmpty()) {
            return null;
        }
        return (ICompletionProposal)proposals.get(0);
    }

    public String getFileNameFromVerissimoMarker(IMarker marker) {
        OVMComplianceCheckHit hit;
        try {
            hit = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return hit.getParserPath().getCanonicalPath();
    }

    public ICompletionProposal getLintingWaiveHitsProposalFromMarker(IMarker marker) {
        block3: {
            try {
                String markerType = marker.getType();
                if (LintingProblemsManager.LINTING_MARKERS.contains(markerType)) break block3;
                return null;
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        OVMComplianceCheckHit hit = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
        return new VerissimoWaiveHitProposal(hit, marker);
    }

    public ICompletionProposal getLintingAutofixProposalFromMarker(IMarker marker) {
        OVMComplianceCheckHit hit;
        block5: {
            block4: {
                try {
                    String markerType = marker.getType();
                    if (LintingProblemsManager.LINTING_MARKERS.contains(markerType)) break block4;
                    return null;
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            hit = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
            if (VerissimoAutofixUtils.getInstance().hasAutofixImplemented(hit.getCheck())) break block5;
            return null;
        }
        return new VerissimoAutofixProposal(hit, marker);
    }

    private void scheduleTimeoutWatchDog(final IProgressMonitor progressMonitor, int timeoutMilliseconds) {
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                progressMonitor.setCanceled(true);
            }
        };
        new Timer().schedule(tt, timeoutMilliseconds);
    }
}

