/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtilsCommon;
import ro.amiq.vlogdt.linter.ui.OVMComplianceReport;

public class VerissimoAutofixUtils
extends VerissimoAutofixUtilsCommon {
    private static VerissimoAutofixUtils fInstance;
    private static final Object fSyncInstance;
    public final String VERISSIMO_AUTOCORRECT_DEFAULT_BLUEPRINT_NAME = "Verissimo Auto-correct";

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerissimoAutofixUtils getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VerissimoAutofixUtils();
            }
        }
        return fInstance;
    }

    @Override
    public IFile getFile(IProject project, ParserPath parserPath) {
        if (project == null || parserPath == null) {
            return null;
        }
        return DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
    }

    public IDocument getDocumentFromFile(IFile file) {
        if (file == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getOpenDocument(file);
        if (document != null) {
            return document;
        }
        try {
            FileDocumentProvider provider = new FileDocumentProvider();
            FileEditorInput input = new FileEditorInput(file);
            provider.connect((Object)input);
            document = provider.getDocument((Object)input);
            provider.disconnect((Object)input);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return document;
    }

    public OVMComplianceReport getOVMComplianceReport(IProject project) {
        IEditorReference[] references;
        if (project == null) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorReference[] iEditorReferenceArray = references = workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            IEditorPart editor = reference.getEditor(false);
            if (editor instanceof OVMComplianceReport && project.equals((Object)((OVMComplianceReport)editor).getProject())) {
                return (OVMComplianceReport)editor;
            }
            ++n2;
        }
        return null;
    }

    public void showErrorDialog(String title, String message, String[] buttonLabels) {
        this.showDialog(title, message, buttonLabels, 1);
    }

    public void showInfoDialog(String title, String message, String[] buttonLabels) {
        this.showDialog(title, message, buttonLabels, 2);
    }

    private void showDialog(String title, String message, String[] buttonLabels, int dialogImageType) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, dialogImageType, buttonLabels, 0);
        dialog.open();
    }

    public String getAIAutofixButtonSuffixIfNecessary(String blueprintName, boolean singleBlueprint) {
        return singleBlueprint || "Verissimo Auto-correct".equals(blueprintName) ? "" : " (" + blueprintName + ")";
    }
}

