/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.autofixes.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.InsertEditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.utils.LintUtils;

public abstract class VerissimoAutofixUtilsCommon {
    public abstract IFile getFile(IProject var1, ParserPath var2);

    public IDocument getDocument(IFile file) {
        if (file == null) {
            return null;
        }
        return this.getDocument(file.getProject(), DVTFileUtils.getInstance().resource2parser((IResource)file));
    }

    public IDocument getDocument(IProject project, ParserPath parserPath) {
        if (project == null || parserPath == null) {
            return null;
        }
        DocumentManager docManager = new DocumentManager();
        try {
            docManager.activate();
            IDocument iDocument = docManager.getDocument(parserPath, true, project);
            return iDocument;
        }
        finally {
            docManager.deactivate();
        }
    }

    public String getParameterValueAsString(OVMComplianceCheck check, String parameterName) {
        return this.getParameterValue(check, parameterName);
    }

    public int getParameterValueAsInt(OVMComplianceCheck check, String parameterName) {
        String parameterValueAsString = this.getParameterValue(check, parameterName);
        return Integer.parseInt(parameterValueAsString);
    }

    public boolean getParameterValueAsBoolean(OVMComplianceCheck check, String parameterName) {
        String parameterValueAsString = this.getParameterValue(check, parameterName);
        return Boolean.parseBoolean(parameterValueAsString);
    }

    private String getParameterValue(OVMComplianceCheck check, String parameterName) {
        if (check == null || parameterName == null) {
            return null;
        }
        Map<String, String> checkProprieties = check.getProperties();
        if (checkProprieties != null && checkProprieties.containsKey(parameterName)) {
            return checkProprieties.get(parameterName);
        }
        Map<String, CheckParameter> allParameters = check.getAllParameters();
        List<CheckParameterOverride> overridenParameters = Arrays.asList((CheckParameterOverride[])check.getClass().getAnnotationsByType(CheckParameterOverride.class));
        CheckParameter parameter = allParameters.get(parameterName);
        String defaultValue = parameter.defaultValue();
        for (CheckParameterOverride oParam : overridenParameters) {
            if (!parameter.name().equals(oParam.name()) || oParam.defaultValue().equals("<<<DVT_INHERITED_PARAMETER_DEFAULT_VALUE>>>")) continue;
            defaultValue = oParam.defaultValue();
        }
        return defaultValue;
    }

    public boolean hasAutofixImplemented(OVMComplianceCheck check) {
        if (check == null) {
            return false;
        }
        CheckAutofix autofixAnnotation = check.getClass().getAnnotation(CheckAutofix.class);
        if (autofixAnnotation == null) {
            return false;
        }
        Class<?> autofixAnnotationValue = autofixAnnotation.value();
        if (autofixAnnotationValue == null) {
            return false;
        }
        String className = autofixAnnotationValue.getCanonicalName();
        return className != null && !className.isEmpty();
    }

    public List<OVMComplianceCheck> getAllAutofixableChecks(OVMProject ovmProject) {
        if (ovmProject == null) {
            return new ArrayList<OVMComplianceCheck>(0);
        }
        ArrayList<OVMComplianceCheck> allChecks = ovmProject.getChecks();
        if (allChecks == null || allChecks.isEmpty()) {
            return new ArrayList<OVMComplianceCheck>(0);
        }
        ArrayList<OVMComplianceCheck> autofixableChecks = new ArrayList<OVMComplianceCheck>();
        for (OVMComplianceCheck check : allChecks) {
            if (!this.hasAutofixImplemented(check)) continue;
            autofixableChecks.add(check);
        }
        return autofixableChecks;
    }

    public void addInlineWaiverForAutocorrectError(VerissimoAutofix autofix, VerissimoAutofixError error, OVMComplianceCheckHit hit, IFile file, IDocument document, Map<OVMComplianceCheckHit, List<EditParameters>> computedWaivers) throws BadLocationException, BadPartitioningException {
        int insertionOffset = document.getLineOffset(hit.getLine() - 1) + document.getLineLength(hit.getLine() - 1);
        if (hit.getLine() < document.getNumberOfLines()) {
            --insertionOffset;
        }
        String indentation = DVTDocumentUtils.getIndent((int)insertionOffset, (IDocument)document);
        ITypedRegion region = ((IDocumentExtension3)document).getPartition("__vlog_partitioning", insertionOffset, false);
        String waiverSuffix = String.valueOf(autofix.getCheck().getName()) + "@" + LintUtils.getFileShortName(hit.getParserPath().path) + "-" + hit.getLine() + "\" DISABLE " + autofix.getCheck().getName();
        String regionType = region.getType();
        if ("__vlog_sl_comment".equals(regionType) || "__vlog_ml_comment".equals(regionType)) {
            InsertEditParameters startWaiver = new InsertEditParameters(autofix, document.getLineOffset(hit.getLine() - 1), "// @DVT_LINTER_WAIVER_START \"" + waiverSuffix, indentation, "\n");
            InsertEditParameters endWaiver = new InsertEditParameters(autofix, region.getOffset() + region.getLength(), "// @DVT_LINTER_WAIVER_END \"" + waiverSuffix, indentation, "\n");
            this.addEditsForWaivers(autofix, hit, file, Arrays.asList(startWaiver, endWaiver));
            if (computedWaivers != null) {
                computedWaivers.putIfAbsent(hit, Arrays.asList(startWaiver, endWaiver));
            }
        } else {
            InsertEditParameters waiver = new InsertEditParameters(autofix, insertionOffset, "// @DVT_LINTER_WAIVER \"" + waiverSuffix, " ", "");
            this.addEditsForWaivers(autofix, hit, file, Arrays.asList(waiver));
            if (computedWaivers != null && error != null) {
                computedWaivers.putIfAbsent(error.getHit(), Arrays.asList(waiver));
            }
        }
    }

    public EditParameters addCommentForAutocorrectError(VerissimoAutofix autofix, OVMComplianceCheckHit hit, IDocument document, String commentText) {
        InsertEditParameters commentEditParameters = null;
        try {
            int offset = document.getLineOffset(hit.getLine() - 1);
            String indent = DVTDocumentUtils.getIndent((int)offset, (IDocument)document);
            commentEditParameters = new InsertEditParameters(autofix, offset, commentText, indent, "\n");
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return commentEditParameters;
    }

    public void addEditsForWaivers(VerissimoAutofix autofix, OVMComplianceCheckHit hit, IFile file, List<EditParameters> waiversForHit) {
        if (hit == null || file == null || waiversForHit == null) {
            return;
        }
        autofix.getEdits().putIfAbsent(hit, new HashMap());
        autofix.getEdits().get(hit).putIfAbsent(file, new ArrayList());
        autofix.getEdits().get(hit).get(file).addAll(waiversForHit);
    }
}

