/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.base.annotations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CheckParameterType {
    BOOLEAN{

        @Override
        public Object parse(String value) {
            if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
                return Boolean.parseBoolean(value);
            }
            throw new NumberFormatException("For input string: \"" + value + "\"");
        }

        @Override
        public boolean isCompatibleWith(String type) {
            return type.equals("boolean") || type.equals("java.lang.Boolean");
        }
    }
    ,
    INTEGER{

        @Override
        public Object parse(String value) {
            return Integer.parseInt(value);
        }

        @Override
        public boolean isCompatibleWith(String type) {
            return type.equals("int") || type.equals("java.lang.Integer");
        }
    }
    ,
    STRING{

        @Override
        public Object parse(String value) {
            return value;
        }

        @Override
        public boolean isCompatibleWith(String type) {
            return type.equals("java.lang.String");
        }
    }
    ,
    CSL_STRING{

        @Override
        public Object parse(String value) {
            HashSet<String> result = new HashSet<String>();
            if (value == null || value.isEmpty()) {
                return result;
            }
            String[] splitPropertyValue = CheckParameterType.splitCommaSeparatedList(value);
            int i = 0;
            while (i < splitPropertyValue.length) {
                if (splitPropertyValue[i] != null) {
                    result.add(splitPropertyValue[i].trim());
                }
                ++i;
            }
            return result;
        }

        @Override
        public boolean isCompatibleWith(String type) {
            return type.equals("java.util.Set<java.lang.String>") || type.equals("java.util.HashSet<java.lang.String>");
        }
    }
    ,
    REGEX{

        @Override
        public Object parse(String value) {
            return Pattern.compile(value);
        }

        @Override
        public boolean isCompatibleWith(String type) {
            return type.equals("java.util.regex.Pattern");
        }
    }
    ,
    CSL_REGEX{

        @Override
        public Object parse(String value) {
            HashSet<Pattern> result = new HashSet<Pattern>();
            if (value == null || value.isEmpty()) {
                return result;
            }
            String[] splitPropertyValue = CheckParameterType.splitCommaSeparatedList(value);
            int i = 0;
            while (i < splitPropertyValue.length) {
                if (splitPropertyValue[i] != null) {
                    String strPattern = splitPropertyValue[i].trim();
                    result.add(Pattern.compile(strPattern));
                }
                ++i;
            }
            return result;
        }

        @Override
        public boolean isCompatibleWith(String type) {
            return type.equals("java.util.Set<java.util.regex.Pattern>") || type.equals("java.util.HashSet<java.util.regex.Pattern>");
        }
    };


    public abstract Object parse(String var1) throws NumberFormatException, PatternSyntaxException;

    public abstract boolean isCompatibleWith(String var1);

    /*
     * Unable to fully structure code
     */
    private static String[] splitCommaSeparatedList(String value) {
        result = new ArrayList<String>();
        previousCommaIndex = 0;
        commaIndex = value.indexOf(44);
        if (commaIndex != -1) ** GOTO lbl17
        return value.split(",");
lbl-1000:
        // 1 sources

        {
            if (value.charAt(commaIndex + 1) == ',') {
                commaIndex = value.indexOf(44, commaIndex + 2);
            } else {
                result.add(value.substring(previousCommaIndex, commaIndex).replace(",,", ","));
                previousCommaIndex = commaIndex + 1;
                commaIndex = value.indexOf(44, commaIndex + 1);
            }
            if (commaIndex != -1) continue;
            result.add(value.substring(previousCommaIndex).replace(",,", ","));
            previousCommaIndex = -1;
lbl17:
            // 3 sources

            ** while (previousCommaIndex != -1)
        }
lbl18:
        // 1 sources

        return result.toArray(new String[result.size()]);
    }
}

