/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.base.annotations;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;

public enum RuleLabel {
    _4_STATE("4-STATE"),
    AGENT("AGENT"),
    AGGREGATE_DATA_TYPE("AGGREGATE_DATA_TYPE"),
    ALWAYS("ALWAYS"),
    AMS("AMS"),
    ANALYSIS_PORT("ANALYSIS_PORT"),
    ARCHITECTURE("ARCHITECTURE"),
    ARGUMENT("ARGUMENT"),
    ARRAY("ARRAY"),
    ASSERTION("ASSERTION"),
    ASSIGNMENT("ASSIGNMENT"),
    BANNED_API("BANNED_API"),
    BASE_CLASS("BASE_CLASS"),
    BEGIN_END("BEGIN_END"),
    BIND("BIND"),
    BUILD_PHASE("BUILD_PHASE"),
    CASE("CASE"),
    CAST("CAST"),
    CHECKING("CHECKING"),
    CLASS("CLASS"),
    CLASS_INSTANTIATION("CLASS_INSTANTIATION"),
    CLOCK("CLOCK"),
    CLOCKING_BLOCK("CLOCKING_BLOCK"),
    CODE_COMPLEXITY("CODE_COMPLEXITY"),
    COMMENT("COMMENT"),
    COMPARISON("COMPARISON"),
    COMPILATION("COMPILATION"),
    COMPONENT("COMPONENT"),
    CONCATENATION("CONCATENATION"),
    CONDITIONAL("CONDITIONAL"),
    CONDITIONAL_DIRECTIVE("CONDITIONAL_DIRECTIVE"),
    CONFIG_DB("CONFIG_DB"),
    CONFIG_OBJECT("CONFIG_OBJECT"),
    CONNECT_PHASE("CONNECT_PHASE"),
    CONSTANT("CONSTANT"),
    CONSTRAINT("CONSTRAINT"),
    CONSTRUCTOR("CONSTRUCTOR"),
    COVERAGE("COVERAGE"),
    COVERGROUP("COVERGROUP"),
    COVERPOINT("COVERPOINT"),
    DEAD_CODE("DEAD_CODE"),
    DECLARATION_ASSIGN("DECLARATION_ASSIGN"),
    DELAY("DELAY"),
    DEPRECATED_API("DEPRECATED_API"),
    DESIGN("DESIGN"),
    DESIGN_INSTANTIATION("DESIGN_INSTANTIATION"),
    DIRECTIVE("DIRECTIVE"),
    DISTRIBUTION("DISTRIBUTION"),
    DOCUMENTATION("DOCUMENTATION"),
    DPI("DPI"),
    DRIVER("DRIVER"),
    DUPLICATE_CODE("DUPLICATE_CODE"),
    EDGE("EDGE"),
    ENUM("ENUM"),
    ENVIRONMENT("ENVIRONMENT"),
    EVENT("EVENT"),
    EVENT_CONTROL("EVENT_CONTROL"),
    EXTEND("EXTEND"),
    EXTERN("EXTERN"),
    FACTORY_CREATE("FACTORY_CREATE"),
    FACTORY_OVERRIDE("FACTORY_OVERRIDE"),
    FACTORY_REGISTRATION("FACTORY_REGISTRATION"),
    FACTORY_REGISTRATION_MACRO("FACTORY_REGISTRATION_MACRO"),
    FIELD("FIELD"),
    FILE("FILE"),
    FINAL("FINAL"),
    FOR("FOR"),
    FORK("FORK"),
    FORMAT_SPECIFIER("FORMAT_SPECIFIER"),
    FORWARD_TYPEDEF("FORWARD_TYPEDEF"),
    FUNCTIONAL("FUNCTIONAL"),
    FUNCTIONAL_COVERAGE("FUNCTIONAL_COVERAGE"),
    FSM("FSM"),
    GENERATE("GENERATE"),
    GLOBAL("GLOBAL"),
    IF("IF"),
    IMPORT("IMPORT"),
    INCLUDE("INCLUDE"),
    INCLUDE_GUARD("INCLUDE_GUARD"),
    INDENTATION("INDENTATION"),
    INITIAL("INITIAL"),
    INITIALIZATION("INITIALIZATION"),
    INSTANTIATION("INSTANTIATION"),
    INTERFACE("INTERFACE"),
    INTERPROCESS_COMMUNICATION("INTERPROCESS_COMMUNICATION"),
    LITERAL_VALUE("LITERAL_VALUE"),
    LOOP("LOOP"),
    MACRO("MACRO"),
    MESSAGING("MESSAGING"),
    METHOD("METHOD"),
    MODPORT("MODPORT"),
    MODULE("MODULE"),
    MONITOR("MONITOR"),
    NAME("NAME"),
    NAME_SPACE("NAME_SPACE"),
    OBJECT("OBJECT"),
    OBJECTION("OBJECTION"),
    OPERATOR("OPERATOR"),
    OPTION("OPTION"),
    OVERRIDE("OVERRIDE"),
    PACK_UNPACK("PACK/UNPACK"),
    PACKAGE("PACKAGE"),
    PARAMETER("PARAMETER"),
    PARENTHESIS("PARENTHESIS"),
    PERFORMANCE("PERFORMANCE"),
    PHASE("PHASE"),
    PORT("PORT"),
    PREDEFINED_METHOD("PREDEFINED_METHOD"),
    PROCEDURAL_STATEMENT("PROCEDURAL_STATEMENT"),
    PROCESS("PROCESS"),
    PROGRAM("PROGRAM"),
    PROPERTY("PROPERTY"),
    RAL("RAL"),
    RANDOM_STABILITY("RANDOM_STABILITY"),
    RANDOMIZATION("RANDOMIZATION"),
    RANGE("RANGE"),
    REGISTER("REGISTER"),
    REGISTER_BLOCK("REGISTER_BLOCK"),
    REGISTER_MAP("REGISTER_MAP"),
    REGISTER_MODEL("REGISTER_MODEL"),
    REGISTRATION_MACRO("REGISTRATION_MACRO"),
    REMOVED_API("REMOVED_API"),
    REPORTING_MACRO("REPORTING_MACRO"),
    RESET("RESET"),
    RETURN("RETURN"),
    RUN_PHASE("RUN_PHASE"),
    SCOREBOARD("SCOREBOARD"),
    SELECT("SELECT"),
    SENSITIVITY_LIST("SENSITIVITY_LIST"),
    SEQUENCE("SEQUENCE"),
    SEQUENCE_ITEM("SEQUENCE_ITEM"),
    SEQUENCER("SEQUENCER"),
    SHADOWING("SHADOWING"),
    SIGNAL("SIGNAL"),
    SINGULAR_DATA_TYPE("SINGULAR_DATA_TYPE"),
    STRING("STRING"),
    STRUCT("STRUCT"),
    STYLING("STYLING"),
    SUBSCRIBER("SUBSCRIBER"),
    SUPER("SUPER"),
    SYNCRONIZATION("SYNCRONIZATION"),
    SYNTHESIS("SYNTHESIS"),
    TASK("TASK"),
    TEST("TEST"),
    TESTBENCH("TESTBENCH"),
    TIMESCALE("TIMESCALE"),
    TLM_PORT("TLM_PORT"),
    TOP_MODULE("TOP_MODULE"),
    TRANSACTION("TRANSACTION"),
    TRANSLATOR("TRANSLATOR"),
    TYPEDEF("TYPEDEF"),
    UVM_DIRECTIVE("UVM_DIRECTIVE"),
    UVM_DO("UVM_DO"),
    UVM_IEEE("UVM_IEEE"),
    UVM_NON_STANDARD("UVM_NON_STANDARD"),
    UVM_SEQUENCE("UVM_SEQUENCE"),
    VERIFICATION("VERIFICATION"),
    VIRTUAL_INTERFACE("VIRTUAL_INTERFACE"),
    VIRTUAL_SEQUENCE("VIRTUAL_SEQUENCE"),
    VIRTUAL_SEQUENCER("VIRTUAL_SEQUENCER"),
    WAIT("WAIT"),
    WHILE("WHILE"),
    WIDTH_MISMATCH("WIDTH_MISMATCH"),
    XMR("XMR");

    private final String value;

    private RuleLabel(String label) {
        this.value = label;
    }

    public static List<String> getAllLabels() {
        return Arrays.asList(RuleLabel.values()).stream().map(x -> x.value).collect(Collectors.toList());
    }

    public static RuleLabel valueOfString(String value) {
        try {
            return RuleLabel.valueOf(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Set<RuleLabel> getLabelsFromCategories(List<OVMComplianceCategory> input) {
        LinkedHashSet<RuleLabel> labels = new LinkedHashSet<RuleLabel>();
        if (input == null) {
            return labels;
        }
        for (OVMComplianceCategory category : input) {
            for (OVMComplianceCheck check : category.getChecks()) {
                if (check.getLabels() == null) continue;
                labels.addAll(check.getLabels());
            }
        }
        return labels;
    }

    public static List<String> getValues(Collection<RuleLabel> labels) {
        if (labels == null) {
            return null;
        }
        return labels.stream().map(RuleLabel::getValue).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return '\"' + this.value + '\"';
    }
}

