/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.flowgraph;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.flowgraph.FlowNode;
import ro.amiq.vlogdt.linter.flowgraph.PredicateState;
import ro.amiq.vlogdt.linter.waivers.WaiversModel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public class EmptyFlowNode
implements FlowNode {
    private int offset;
    private int virtualOffset;
    private String description;
    private RfNamedElement block;
    private int cachedHashCode;

    public EmptyFlowNode(int offset) {
        this.offset = offset;
        this.virtualOffset = -1;
        this.description = "EMPTY";
        this.cachedHashCode = this.getHashCode();
    }

    public EmptyFlowNode(RfNamedElement block, String description) {
        this.block = block;
        this.offset = block.getOffset();
        this.virtualOffset = block.getDeclaration().getStartVirtualOffset();
        this.description = description;
        this.cachedHashCode = this.getHashCode();
    }

    public EmptyFlowNode(int offset, String description) {
        this.block = new RfActionBlock("dummy", false, 0L, null, "dummy", 0, true);
        this.offset = offset;
        this.virtualOffset = -1;
        this.description = description;
        this.cachedHashCode = this.getHashCode();
    }

    public RfNamedElement getBlock() {
        return this.block;
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        return this.block.getEnclosingScope();
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getVirtualOffset() {
        return this.virtualOffset;
    }

    @Override
    public int getLine() {
        return 0;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public boolean hasElement(RfNamedElement namedElement) {
        return false;
    }

    @Override
    public PredicateState getPredicateState() {
        return PredicateState.UNDEFINED;
    }

    @Override
    public void setPredicateState(PredicateState value) {
    }

    @Override
    public void computePredicateStateValue(int depth, Predicate<FlowNode> predicate, Map<String, Set<RfNamedElement>> visitedFunctions, boolean checkInsideMethodCall, OVMComplianceCheck check, WaiversModel projectWaivers) {
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    private int getHashCode() {
        int result = 1;
        result = 31 * result + this.offset;
        result = 31 * result + this.virtualOffset;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmptyFlowNode other = (EmptyFlowNode)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.virtualOffset != other.virtualOffset) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.block, other.block);
    }
}

