/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.flowgraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.flowgraph.ComparatorbyOffset;
import ro.amiq.vlogdt.linter.flowgraph.EmptyFlowNode;
import ro.amiq.vlogdt.linter.flowgraph.FlowNode;
import ro.amiq.vlogdt.linter.flowgraph.MethodFlowNode;
import ro.amiq.vlogdt.linter.flowgraph.OperatorFlowNode;
import ro.amiq.vlogdt.linter.flowgraph.PredicateState;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.waivers.WaiversModel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfWait;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class ExecutionFlowGraph {
    private static final String WAIT = "WAIT";
    private static final String ASSERT = "ASSERT";
    private RfNamedElement fEnclosingScope;
    private Map<FlowNode, ArrayList<FlowNode>> fGraph;
    private FlowNode START_NODE;
    private FlowNode END_NODE;
    private Predicate<FlowNode> fPredicate;
    private Map<String, Set<RfNamedElement>> visitedScopes;
    private boolean checkInsideMethodCall;
    private OVMComplianceCheck fOVMComplianceCheck;
    private WaiversModel fProjectWaivers;
    private static final Predicate<FlowNode> DEPTH_PREDICATE = node -> node.getPredicateState() == PredicateState.TRUE;
    private static final HidOperatorQualifier[] IS_LOOP_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_LOOP_EXPRESSION, HidOperatorQualifier.IS_DECLARATION_ASSIGN};
    private static final HidOperatorQualifier[] IS_CASE_ITEM_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION};
    private static final HidOperatorQualifier[] IS_CONDITIONAL_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION};
    private static final boolean DEBUG_FLAG = false;

    protected ExecutionFlowGraph(RfNamedElement enclosingScope, Predicate<FlowNode> predicate, Map<String, Set<RfNamedElement>> visitedScopes, boolean checkInsideMethodCall, OVMComplianceCheck check, WaiversModel projectWaivers) {
        this.fOVMComplianceCheck = check;
        this.fProjectWaivers = projectWaivers;
        this.fEnclosingScope = enclosingScope;
        this.fGraph = new HashMap<FlowNode, ArrayList<FlowNode>>();
        this.checkInsideMethodCall = checkInsideMethodCall;
        this.fPredicate = predicate;
        this.visitedScopes = visitedScopes;
        this.setStartAndEndNode();
        this.createFlowGraph();
    }

    public ExecutionFlowGraph(RfNamedElement enclosingScope, OVMComplianceCheck check, WaiversModel projectWaivers, boolean checkInsideMethodCall) {
        this.fOVMComplianceCheck = check;
        this.fProjectWaivers = projectWaivers;
        this.fEnclosingScope = enclosingScope;
        this.fGraph = new HashMap<FlowNode, ArrayList<FlowNode>>();
        this.checkInsideMethodCall = checkInsideMethodCall;
        this.visitedScopes = new HashMap<String, Set<RfNamedElement>>();
        this.setStartAndEndNode();
        this.createFlowGraph();
    }

    public void reset(OVMComplianceCheck check) {
        this.fOVMComplianceCheck = check;
        this.fGraph.keySet().forEach(node -> node.setPredicateState(PredicateState.UNDEFINED));
    }

    private void setStartAndEndNode() {
        int startOffset = this.fEnclosingScope.getStartOffset();
        int endOffset = this.fEnclosingScope.getEndOffset();
        if (this.fEnclosingScope instanceof RfFunction && this.fEnclosingScope.isExtern() && ((RfFunction)this.fEnclosingScope).getImplementation() != null) {
            startOffset = ((RfFunction)this.fEnclosingScope).getImplementation().getStartOffset();
            endOffset = ((RfFunction)this.fEnclosingScope).getImplementation().getEndOffset();
        }
        this.START_NODE = new EmptyFlowNode(startOffset, "START");
        this.END_NODE = new EmptyFlowNode(endOffset, "END");
    }

    private void addNode(FlowNode node) {
        if (!this.fGraph.containsKey(node)) {
            this.fGraph.put(node, new ArrayList());
        }
    }

    private void addEdge(FlowNode parent, FlowNode child) {
        ArrayList<FlowNode> childs = this.fGraph.get(parent);
        if (childs == null) {
            return;
        }
        childs.add(child);
    }

    private boolean skipFunction() {
        boolean skipFunction;
        Set<RfNamedElement> localVisited = this.visitedScopes.get(this.fEnclosingScope.getFullName());
        boolean visited = localVisited != null && localVisited.contains(this.fEnclosingScope);
        boolean bl = skipFunction = this.checkInsideMethodCall && !this.fOVMComplianceCheck.getOVMProject().getAllNonXVMFunctionCallContainers().contains(this.fEnclosingScope);
        return visited || skipFunction;
    }

    private void createFlowGraph() {
        if (this.skipFunction()) {
            return;
        }
        List<FlowNode> nodes = this.collectNodes(this.fEnclosingScope);
        if (nodes.isEmpty()) {
            return;
        }
        nodes.add(0, this.START_NODE);
        nodes.add(this.END_NODE);
        this.bindNodeList(nodes, this.getLocalMembers(this.fEnclosingScope));
    }

    private List<RfNamedElement> getLocalMembers(RfNamedElement scope) {
        ArrayList<RfNamedElement> localMembers = new ArrayList<RfNamedElement>();
        List<RfMembersHolder> tempMembers = scope.getLocalMembers(RfActionBlock.class);
        if (tempMembers != null) {
            for (RfNamedElement rfNamedElement : tempMembers) {
                localMembers.add(rfNamedElement);
            }
        }
        if ((tempMembers = scope.getLocalMembers(RfWait.class)) != null) {
            for (RfNamedElement rfNamedElement : tempMembers) {
                localMembers.add(rfNamedElement);
            }
        }
        if ((tempMembers = scope.getLocalMembers(RfAssertExpect.class)) != null) {
            for (RfNamedElement rfNamedElement : tempMembers) {
                localMembers.add(rfNamedElement);
            }
        }
        return localMembers;
    }

    private void bindNodes(FlowNode start, FlowNode end, List<RfNamedElement> members) {
        if (start.equals(this.START_NODE)) {
            this.addEdge(start, end);
            return;
        }
        if (this.isReturnStatement(start) || this.isSimulationSystemTask(start)) {
            this.addEdge(start, this.END_NODE);
            return;
        }
        if ((members = this.extractBlocksInBetween(start, end, members)).isEmpty()) {
            this.addEdge(start, end);
            return;
        }
        boolean foundDefaultBlock = false;
        for (RfNamedElement member : members) {
            RfActionBlock actionBlock;
            this.bindBlock(start, end, member);
            if (!(member instanceof RfActionBlock) || !(actionBlock = (RfActionBlock)member).isElse() && !actionBlock.hasDefaultCaseItem()) continue;
            foundDefaultBlock = true;
        }
        if (!(foundDefaultBlock || !(start instanceof OperatorFlowNode) || !((OperatorFlowNode)start).getOperator().isActionBlockCondition() || ((OperatorFlowNode)start).getOperator().isCaseItemCondition() || ((OperatorFlowNode)start).getOperator().isAssertStatement() || end instanceof OperatorFlowNode && ((OperatorFlowNode)end).isElseIfCondition())) {
            this.addEdge(start, end);
        }
    }

    private void bindBlock(FlowNode start, FlowNode end, RfNamedElement block) {
        List<FlowNode> blockNodes = this.collectNodes(block);
        if (blockNodes.isEmpty()) {
            blockNodes.add(new EmptyFlowNode(block.getOffset()));
        }
        if (block instanceof RfActionBlock && ((RfActionBlock)block).isFor()) {
            blockNodes = blockNodes.stream().filter(e -> !(e instanceof OperatorFlowNode) || !((OperatorFlowNode)e).getOperator().hasQualifier(HidOperatorQualifier.IS_DECLARATION_ASSIGN.value())).collect(Collectors.toList());
        }
        List<RfNamedElement> members = this.getLocalMembers(block);
        if (block instanceof RfActionBlock && ((RfActionBlock)block).isCase()) {
            int i = 0;
            while (i < blockNodes.size()) {
                this.addNode(blockNodes.get(i));
                this.bindNodes(start, blockNodes.get(i), members);
                this.bindNodes(blockNodes.get(i), end, members);
                ++i;
            }
        } else {
            blockNodes.add(0, start);
            blockNodes.add(end);
            this.bindNodeList(blockNodes, members);
        }
    }

    private void bindNodeList(List<FlowNode> actionNodes, List<RfNamedElement> members) {
        int increment = 1;
        int i = 0;
        while (i < actionNodes.size() - 1) {
            this.addNode(actionNodes.get(i));
            FlowNode startNode = actionNodes.get(i);
            FlowNode endNode = actionNodes.get(i + increment);
            if (endNode instanceof OperatorFlowNode && ((OperatorFlowNode)endNode).isIfCondition() && !((OperatorFlowNode)endNode).isElseIfCondition()) {
                this.bindNodes(startNode, endNode, members);
                if (i + ++increment < actionNodes.size()) {
                    node = actionNodes.get(i + increment);
                    while (node instanceof OperatorFlowNode && ((OperatorFlowNode)node).isElseIfCondition()) {
                        this.bindNodes(startNode, actionNodes.get(i + increment), members);
                        if (i + ++increment >= actionNodes.size()) break;
                        node = actionNodes.get(i + increment);
                    }
                }
                increment = 1;
            } else if (startNode instanceof OperatorFlowNode && ((OperatorFlowNode)startNode).isIfCondition()) {
                node = actionNodes.get(i + increment);
                ArrayList<OperatorFlowNode> nodeList = new ArrayList<OperatorFlowNode>();
                while (node instanceof OperatorFlowNode && ((OperatorFlowNode)node).isElseIfCondition()) {
                    nodeList.add((OperatorFlowNode)node);
                    if (i + ++increment >= actionNodes.size()) break;
                    node = actionNodes.get(i + increment);
                }
                this.bindNodes(startNode, node, members);
                for (OperatorFlowNode elseIfNode : nodeList) {
                    this.bindNodes(elseIfNode, node, members);
                }
                i = i + increment - 1;
                increment = 1;
            } else {
                this.bindNodes(actionNodes.get(i), actionNodes.get(i + 1), members);
            }
            if (this.isReturnStatement(actionNodes.get(i))) break;
            ++i;
        }
    }

    private boolean isReturnStatement(FlowNode node) {
        return node instanceof OperatorFlowNode && ((OperatorFlowNode)node).getOperator() != null && ((OperatorFlowNode)node).getOperator().isReturnStatement();
    }

    private boolean isSimulationSystemTask(FlowNode node) {
        if (!(node instanceof MethodFlowNode)) {
            return false;
        }
        RfHid function = ((MethodFlowNode)node).getFunction();
        if (!(function.getElement() instanceof RfPredefinedFunction)) {
            return false;
        }
        return "$exit".equals(function.getName()) || "$finish".equals(function.getName());
    }

    private List<RfNamedElement> extractBlocksInBetween(FlowNode start, FlowNode end, List<RfNamedElement> blocks) {
        RfHidOperator endOperator;
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (blocks == null || blocks.isEmpty() || start.equals(this.START_NODE)) {
            return result;
        }
        RfHidOperator startOperator = start instanceof OperatorFlowNode ? ((OperatorFlowNode)start).getOperator() : null;
        RfHidOperator rfHidOperator = endOperator = end instanceof OperatorFlowNode ? ((OperatorFlowNode)end).getOperator() : null;
        if (startOperator != null && startOperator.isCaseCondition() && endOperator != null && endOperator.isCaseItemCondition()) {
            return result;
        }
        if (end instanceof OperatorFlowNode && ((OperatorFlowNode)end).isElseIfCondition()) {
            return result;
        }
        for (RfNamedElement block : blocks) {
            int offset = block.getOffset();
            int virtualOffset = block.getDeclaration().getStartVirtualOffset();
            boolean afterStart = false;
            if (offset >= start.getOffset()) {
                afterStart = offset != start.getOffset() || virtualOffset == -1 || start.getVirtualOffset() == -1 || virtualOffset >= start.getVirtualOffset();
            }
            boolean beforeEnd = false;
            if (offset <= end.getOffset()) {
                if (offset < end.getOffset()) {
                    beforeEnd = true;
                } else if (offset == end.getOffset() && virtualOffset != -1 && end.getVirtualOffset() != -1 && virtualOffset >= end.getVirtualOffset()) {
                    beforeEnd = false;
                }
            }
            boolean inBetween = false;
            if (afterStart && beforeEnd) {
                inBetween = true;
            }
            if (block instanceof RfActionBlock) {
                RfActionBlock actionBlock = (RfActionBlock)block;
                if (actionBlock.isFor()) {
                    if (inBetween && endOperator != null && actionBlock.getHidOperators(IS_LOOP_EXPRESSION, true).contains(endOperator)) {
                        inBetween = false;
                    } else if (!inBetween && startOperator != null && startOperator.isForCondition() && actionBlock.getHidOperators(IS_LOOP_EXPRESSION, true).contains(startOperator)) {
                        inBetween = true;
                    }
                }
                if (actionBlock.isCaseItem() && inBetween && startOperator != null && startOperator.isCaseItemCondition() && actionBlock.getHidOperators(IS_CASE_ITEM_EXPRESSION, true).contains(startOperator)) {
                    result.add(actionBlock);
                    break;
                }
                if (actionBlock.isElsIf() && inBetween && startOperator != null && startOperator.isIfCondition() && !actionBlock.getHidOperators(IS_CONDITIONAL_EXPRESSION, true).contains(startOperator)) continue;
            }
            if (!inBetween) continue;
            result.add(block);
        }
        return result;
    }

    private List<FlowNode> collectNodes(final RfNamedElement enclosingScope) {
        List<RfNamedElement> blocks;
        final ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
        if (enclosingScope.getHidHolder() != null) {
            enclosingScope.getHidHolder().visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidObject>(){

                public boolean visit(IHidObject hidObject) {
                    switch (hidObject.getHidKind()) {
                        case OPERATOR: {
                            RfHidOperator hidOperator = (RfHidOperator)hidObject;
                            if (LintUtils.isInsideXVMReportingMacro(ExecutionFlowGraph.this.fOVMComplianceCheck.getOVMProject().getLibraryKind() == 2, hidOperator.getReparseInfo())) {
                                return true;
                            }
                            if (hidOperator.isComplete() && !hidOperator.isActionBlockCondition() && !((RfHidOperator)hidObject).isAssociation()) {
                                nodes.add(new OperatorFlowNode((RfHidOperator)hidObject, enclosingScope));
                            }
                            return true;
                        }
                        case HID: {
                            if (!(hidObject instanceof RfHid)) {
                                return true;
                            }
                            if (!((RfHid)hidObject).isMethodCall(false)) {
                                return true;
                            }
                            if (LintUtils.isInsideXVMReportingMacro(ExecutionFlowGraph.this.fOVMComplianceCheck.getOVMProject().getLibraryKind() == 2, ((RfHid)hidObject).getReparseInfo())) {
                                return true;
                            }
                            IRfNamedElement element = ((RfHid)hidObject).getElement();
                            if (element instanceof RfFunction) {
                                MethodFlowNode methodFlowNode = new MethodFlowNode((RfHid)hidObject, ((RfHid)hidObject).getOccurrence(), enclosingScope);
                                if (element instanceof RfPredefinedFunction && ((RfPredefinedFunction)element).getName().startsWith("$") && !ExecutionFlowGraph.this.isSimulationSystemTask(methodFlowNode)) {
                                    return true;
                                }
                                nodes.add(methodFlowNode);
                            }
                            return true;
                        }
                    }
                    return true;
                }

                public Class<IHidObject> getType() {
                    return IHidObject.class;
                }
            });
        }
        if ((blocks = this.getLocalMembers(enclosingScope)) != null) {
            for (final RfNamedElement block : blocks) {
                if (block instanceof RfActionBlock) {
                    RfActionBlock actionBlock = (RfActionBlock)block;
                    if (actionBlock.isForever()) {
                        nodes.add(new EmptyFlowNode(actionBlock, IRfActionBlockElement.BlockQualifier.FOREVER.toString()));
                        continue;
                    }
                    if (actionBlock.isForkJoin() || actionBlock.isForkJoinAny() || actionBlock.isForkJoinNone()) {
                        nodes.add(new EmptyFlowNode(actionBlock, IRfActionBlockElement.BlockQualifier.FORK_JOIN.toString()));
                        continue;
                    }
                    if (actionBlock.isSimpleBeginEnd()) {
                        nodes.add(new EmptyFlowNode(actionBlock, IRfActionBlockElement.BlockQualifier.BEGIN_END.toString()));
                        continue;
                    }
                    if (actionBlock.isForEach()) {
                        nodes.add(new EmptyFlowNode(actionBlock, IRfActionBlockElement.BlockQualifier.FOREACH.toString()));
                        continue;
                    }
                    if (actionBlock.isDoWhile()) {
                        nodes.add(new EmptyFlowNode(actionBlock, IRfActionBlockElement.BlockQualifier.DO.toString()));
                        continue;
                    }
                }
                if (block instanceof RfAssertExpect) {
                    IHidObject assertExpression = ((RfAssertExpect)block).getExpression();
                    if (assertExpression instanceof RfHidOperator) {
                        nodes.add(new OperatorFlowNode((RfHidOperator)assertExpression, enclosingScope));
                        continue;
                    }
                    nodes.add(new EmptyFlowNode(block, ASSERT));
                    continue;
                }
                if (block instanceof RfWait) {
                    nodes.add(new EmptyFlowNode(block, WAIT));
                    continue;
                }
                if (block.getHidHolder() == null) continue;
                block.getHidHolder().visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidOperator>(){

                    public boolean visit(IHidOperator hidOperator) {
                        if (hidOperator instanceof RfHidOperator) {
                            if (hidOperator.isActionBlockCondition()) {
                                OperatorFlowNode operatorFlowNode = new OperatorFlowNode((RfHidOperator)hidOperator, block);
                                List filteredList = nodes.stream().filter(e -> !(e instanceof MethodFlowNode) || !operatorFlowNode.containsMethodCall(((MethodFlowNode)e).getFunction())).collect(Collectors.toList());
                                nodes.clear();
                                nodes.addAll(filteredList);
                                nodes.add(operatorFlowNode);
                            } else if (((RfHidOperator)hidOperator).hasQualifier(HidOperatorQualifier.IS_DECLARATION_ASSIGN.value())) {
                                nodes.add(new OperatorFlowNode((RfHidOperator)hidOperator, block));
                            }
                        }
                        return true;
                    }

                    public Class<IHidOperator> getType() {
                        return IHidOperator.class;
                    }
                });
            }
        }
        nodes.sort(new ComparatorbyOffset());
        return nodes;
    }

    private FlowNode findNode(DVTPair<Integer, Integer> offset) {
        if (this.fGraph == null || this.fGraph.isEmpty()) {
            return null;
        }
        for (Map.Entry<FlowNode, ArrayList<FlowNode>> entry : this.fGraph.entrySet()) {
            FlowNode key = entry.getKey();
            if (key.equals(this.START_NODE) || key.equals(this.END_NODE) || key.getOffset() != ((Integer)offset.getKey()).intValue() || key.getVirtualOffset() != ((Integer)offset.getValue()).intValue()) continue;
            return key;
        }
        return null;
    }

    public boolean checkPredicateForEachPossiblePath() {
        return this.checkPredicateForEachPossiblePath((DVTPair<Integer, Integer>)new DVTPair((Object)0, (Object)-1), (DVTPair<Integer, Integer>)new DVTPair((Object)Integer.MAX_VALUE, (Object)-1), 0);
    }

    public boolean checkPredicateForEachPossiblePath(DVTPair<Integer, Integer> sourceOffset, DVTPair<Integer, Integer> endOffset) {
        return this.checkPredicateForEachPossiblePath(sourceOffset, endOffset, 0);
    }

    protected boolean checkPredicateForEachPossiblePath(int depth) {
        if (this.skipFunction()) {
            return false;
        }
        return this.checkPredicateForEachPossiblePath((DVTPair<Integer, Integer>)new DVTPair((Object)0, (Object)-1), (DVTPair<Integer, Integer>)new DVTPair((Object)Integer.MAX_VALUE, (Object)-1), depth);
    }

    private boolean checkPredicateForEachPossiblePath(DVTPair<Integer, Integer> sourceOffset, DVTPair<Integer, Integer> endOffset, int depth) {
        FlowNode endNode;
        if (this.fEnclosingScope.getDeclaration() != null && this.fProjectWaivers.pathIsPrewaived(this.fEnclosingScope.getDeclaration().getParserPath(), this.fOVMComplianceCheck)) {
            return false;
        }
        FlowNode startNode = (Integer)sourceOffset.getKey() == 0 ? this.START_NODE : this.findNode(sourceOffset);
        FlowNode flowNode = endNode = (Integer)endOffset.getKey() == Integer.MAX_VALUE ? this.END_NODE : this.findNode(endOffset);
        if (startNode == null || endNode == null) {
            return false;
        }
        if (this.fPredicate == null) {
            return false;
        }
        if (!this.isPathReachable(startNode, endNode)) {
            return false;
        }
        this.fOVMComplianceCheck.notifyCheckAlive();
        LinkedHashSet<FlowNode> path = new LinkedHashSet<FlowNode>();
        PredicateState value = this.checkPredicateForEachPossiblePathUtil(startNode, endNode, path, depth);
        return value == PredicateState.TRUE;
    }

    private PredicateState checkPredicateForEachPossiblePathUtil(FlowNode currentNode, FlowNode endNode, LinkedHashSet<FlowNode> path, int depth) {
        this.fOVMComplianceCheck.notifyCheckAlive();
        path.add(currentNode);
        if (this.checkInsideMethodCall && !(currentNode instanceof EmptyFlowNode) && currentNode.getPredicateState() == PredicateState.UNDEFINED) {
            Set<RfNamedElement> localVisited = this.visitedScopes.get(this.fEnclosingScope.getFullName());
            if (localVisited == null) {
                localVisited = new HashSet<RfNamedElement>();
                this.visitedScopes.put(this.fEnclosingScope.getFullName(), localVisited);
            }
            localVisited.add(this.fEnclosingScope);
            currentNode.computePredicateStateValue(depth, this.fPredicate, this.visitedScopes, this.checkInsideMethodCall, this.fOVMComplianceCheck, this.fProjectWaivers);
            localVisited.remove(this.fEnclosingScope);
        }
        if (this.fPredicate.test(currentNode)) {
            path.remove(currentNode);
            return PredicateState.UNDEFINED;
        }
        if (currentNode.equals(endNode)) {
            if (!this.isPredicateValueForPathTrue(path)) {
                return PredicateState.FALSE;
            }
            path.remove(currentNode);
            return PredicateState.UNDEFINED;
        }
        List adjNodes = this.fGraph.get(currentNode);
        if (adjNodes != null) {
            for (FlowNode adjNode : adjNodes) {
                PredicateState state;
                if (path.contains(adjNode) || (state = this.checkPredicateForEachPossiblePathUtil(adjNode, endNode, path, depth)) != PredicateState.FALSE) continue;
                return PredicateState.FALSE;
            }
        }
        path.remove(currentNode);
        return PredicateState.TRUE;
    }

    private boolean isPredicateValueForPathTrue(Set<FlowNode> path) {
        return path.stream().anyMatch(this.fPredicate);
    }

    private boolean isPathReachable(FlowNode startNode, FlowNode endNode) {
        if (startNode.equals(endNode)) {
            return true;
        }
        HashSet<FlowNode> visited = new HashSet<FlowNode>();
        LinkedList<FlowNode> queue = new LinkedList<FlowNode>();
        visited.add(startNode);
        queue.add(startNode);
        while (!queue.isEmpty()) {
            startNode = (FlowNode)queue.poll();
            if (this.fGraph.get(startNode) == null) continue;
            for (FlowNode adjNode : this.fGraph.get(startNode)) {
                if (adjNode.equals(endNode)) {
                    return true;
                }
                if (visited.contains(adjNode)) continue;
                visited.add(adjNode);
                queue.add(adjNode);
            }
        }
        return false;
    }

    private List<List<FlowNode>> computeAllPathsBetween(FlowNode start, FlowNode end) {
        ArrayList<List<FlowNode>> result = new ArrayList<List<FlowNode>>();
        HashSet<FlowNode> visitedNodes = new HashSet<FlowNode>();
        ArrayList<FlowNode> localPath = new ArrayList<FlowNode>();
        localPath.add(start);
        this.computeAllPathsBFS(result, start, end, visitedNodes, localPath);
        return result;
    }

    private void computeAllPathsBFS(List<List<FlowNode>> result, FlowNode start, FlowNode end, HashSet<FlowNode> visitedNodes, List<FlowNode> localPath) {
        visitedNodes.add(start);
        if (start.equals(end)) {
            ArrayList<FlowNode> path = new ArrayList<FlowNode>();
            path.addAll(localPath);
            result.add(path);
            visitedNodes.remove(start);
            return;
        }
        ArrayList<FlowNode> arrayList = this.fGraph.get(start);
        if (arrayList != null) {
            for (FlowNode i : arrayList) {
                if (visitedNodes.contains(i)) continue;
                localPath.add(i);
                this.computeAllPathsBFS(result, i, end, visitedNodes, localPath);
                localPath.remove(i);
            }
        }
        visitedNodes.remove(start);
    }

    public void setPredicate(Predicate<FlowNode> predicate) {
        this.fPredicate = predicate;
    }

    public void setPredicateWithDepth(Predicate<FlowNode> predicate) {
        this.fPredicate = predicate.or(DEPTH_PREDICATE);
    }

    public void enableCheckingInsideMethodCall(boolean value) {
        this.checkInsideMethodCall = value;
    }

    public void clean() {
        this.fGraph.clear();
        this.visitedScopes.clear();
    }
}

