/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.flowgraph;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.flowgraph.ExecutionFlowGraph;
import ro.amiq.vlogdt.linter.flowgraph.FlowNode;
import ro.amiq.vlogdt.linter.flowgraph.PredicateState;
import ro.amiq.vlogdt.linter.waivers.WaiversModel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

public class MethodFlowNode
implements FlowNode {
    private RfHid function;
    private HidOccurrence occurrence;
    private PredicateState predicateState;
    private IRfScopeElement enclosingScope;
    private int cachedHashCode;

    public MethodFlowNode(RfHid function, HidOccurrence occurrence, RfNamedElement enclosingScope) {
        this.function = function;
        this.occurrence = occurrence;
        this.predicateState = PredicateState.UNDEFINED;
        this.enclosingScope = enclosingScope;
        this.cachedHashCode = this.getHashCode();
    }

    public RfHid getFunction() {
        return this.function;
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        return this.enclosingScope;
    }

    public String toString() {
        return this.function.toString();
    }

    @Override
    public int getOffset() {
        return this.occurrence.getOffset();
    }

    @Override
    public int getVirtualOffset() {
        return this.occurrence.getVirtualOffset();
    }

    @Override
    public int getLine() {
        return this.occurrence.getLine();
    }

    @Override
    public boolean hasElement(RfNamedElement namedElement) {
        return this.function.getElement().equals(namedElement);
    }

    @Override
    public PredicateState getPredicateState() {
        return this.predicateState;
    }

    @Override
    public void setPredicateState(PredicateState value) {
        this.predicateState = value;
    }

    @Override
    public void computePredicateStateValue(int depth, Predicate<FlowNode> predicate, Map<String, Set<RfNamedElement>> visitedFunctions, boolean checkInsideMethodCall, OVMComplianceCheck check, WaiversModel projectWaivers) {
        if (!(this.function.getElement() instanceof RfFunction)) {
            return;
        }
        RfFunction functionElem = (RfFunction)this.function.getElement();
        ExecutionFlowGraph executionFlowGraph = new ExecutionFlowGraph(functionElem, predicate, visitedFunctions, checkInsideMethodCall, check, projectWaivers);
        boolean value = executionFlowGraph.checkPredicateForEachPossiblePath(depth + 1);
        this.predicateState = value ? PredicateState.TRUE : PredicateState.FALSE;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    private int getHashCode() {
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.occurrence == null ? 0 : this.occurrence.hashCode());
        result = 31 * result + (this.enclosingScope == null ? 0 : this.enclosingScope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodFlowNode other = (MethodFlowNode)obj;
        if (!Objects.equals((Object)this.function, (Object)other.function)) {
            return false;
        }
        if (!Objects.equals(this.occurrence, other.occurrence)) {
            return false;
        }
        return Objects.equals(this.enclosingScope, other.enclosingScope);
    }
}

