/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.flowgraph;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.flowgraph.ExecutionFlowGraph;
import ro.amiq.vlogdt.linter.flowgraph.FlowNode;
import ro.amiq.vlogdt.linter.flowgraph.PredicateState;
import ro.amiq.vlogdt.linter.waivers.WaiversModel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class OperatorFlowNode
implements FlowNode {
    RfHidOperator operator;
    private static final Set<HidFlatteningOption> ONLY_HIDS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS));
    private PredicateState predicateState;
    private RfNamedElement enclosingScope;
    private int cachedHashCode;
    private Set<IHid> flattenHids;

    public OperatorFlowNode(RfHidOperator operator, RfNamedElement enclosingScope) {
        this.operator = operator;
        this.enclosingScope = enclosingScope;
        this.predicateState = PredicateState.UNDEFINED;
        this.cachedHashCode = this.getHashCode();
    }

    public boolean isIfCondition() {
        return this.operator.isIfCondition();
    }

    public RfHidOperator getOperator() {
        return this.operator;
    }

    public boolean isElseIfCondition() {
        boolean isIfCondition = this.isIfCondition();
        if (!isIfCondition) {
            return false;
        }
        if (!(this.enclosingScope instanceof RfActionBlock)) {
            return false;
        }
        return ((RfActionBlock)this.enclosingScope).isElsIf();
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        return this.enclosingScope;
    }

    public boolean containsMethodCall(RfHid methodCall) {
        if (this.flattenHids == null) {
            this.flattenHids = HidUtils.flattenToHids((IHidObject)this.operator.getLHValue(), ONLY_HIDS);
        }
        return this.flattenHids.contains((Object)methodCall);
    }

    public boolean containsMethodCall(String methodName, IHid parentHid) {
        if (this.flattenHids == null) {
            this.flattenHids = HidUtils.flattenToHids((IHidObject)this.operator.getLHValue(), ONLY_HIDS);
        }
        for (IHid hid : this.flattenHids) {
            if (!(hid instanceof RfHid) || !((RfHid)hid).isMethodCall(true) || !methodName.equals(hid.getName())) continue;
            if (parentHid == null) {
                return true;
            }
            Hid parent = ((RfHid)hid).getParentHid();
            if (parent == null || !parent.equals((Object)parentHid)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.operator.toString();
    }

    @Override
    public int getOffset() {
        return this.operator.getOffset();
    }

    @Override
    public int getVirtualOffset() {
        return this.operator.getVirtualOffset();
    }

    @Override
    public int getLine() {
        return this.operator.getLine();
    }

    @Override
    public boolean hasElement(RfNamedElement namedElement) {
        return false;
    }

    @Override
    public PredicateState getPredicateState() {
        return this.predicateState;
    }

    @Override
    public void setPredicateState(PredicateState value) {
        this.predicateState = value;
    }

    @Override
    public void computePredicateStateValue(int depth, Predicate<FlowNode> predicate, Map<String, Set<RfNamedElement>> visitedFunctions, boolean checkInsideMethodCall, OVMComplianceCheck check, WaiversModel projectWaivers) {
        boolean result = false;
        if (this.flattenHids == null) {
            this.flattenHids = HidUtils.flattenToHids((IHidObject)this.operator.getLHValue(), ONLY_HIDS);
        }
        for (IHid hid : this.flattenHids) {
            RfFunction functionElem;
            RfHid hidElem;
            if (!(hid instanceof RfHid) || !(hidElem = (RfHid)hid).isMethodCall(true) || !(hidElem.getElement() instanceof RfFunction) || (functionElem = (RfFunction)hidElem.getElement()) == null) continue;
            ExecutionFlowGraph executionFlowGraph = new ExecutionFlowGraph(functionElem, predicate, visitedFunctions, checkInsideMethodCall, check, projectWaivers);
            result |= executionFlowGraph.checkPredicateForEachPossiblePath(depth + 1);
        }
        this.predicateState = result ? PredicateState.TRUE : PredicateState.FALSE;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    private int getHashCode() {
        int result = 1;
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.enclosingScope == null ? 0 : this.enclosingScope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatorFlowNode other = (OperatorFlowNode)obj;
        if (!Objects.equals(this.operator, other.operator)) {
            return false;
        }
        return Objects.equals(this.enclosingScope, other.enclosingScope);
    }
}

