/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.generate;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.linter.ui.LinterHTML5ReportBrowser;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.ResourceSelectionDialog;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;

public abstract class AbstractGenerateHandler
extends AbstractHandler {
    protected String location = "";
    private String jobName;
    private String actionName;
    private String locationDescription;

    protected AbstractGenerateHandler(String jobName, String actionName, String locationDescription) {
        this.jobName = jobName;
        this.actionName = actionName;
        this.locationDescription = locationDescription;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource selectedResource = this.getSelectedResource(event);
        final IProject selectedProject = this.getProject(selectedResource);
        if (selectedProject == null) {
            return null;
        }
        String htmlDocLocation = selectedProject.getName().equals("DVT-Settings") ? System.getProperty("user.home") : selectedProject.getLocation().toOSString();
        Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        final SavingDialog dialog = new SavingDialog(currentShell, this.actionName, this.locationDescription, "Choose generating location", "Generate", this.isCustomRuleset(), false);
        dialog.setLocation(htmlDocLocation);
        if (dialog.open() == 1) {
            return null;
        }
        Job job = new Job(this.jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AbstractGenerateHandler.this.location = dialog.getLocation();
                    monitor.beginTask(AbstractGenerateHandler.this.jobName, 100);
                    if (!DVTSplashMLT.INSTANCE.cc(false, new String[]{"F73765F6C696E74"})) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    AbstractGenerateHandler.this.generateAndOpenFile(selectedProject, dialog.getCustomRulesetLocation());
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                    DVTSplashMLT.INSTANCE.i(false, "F73765F6C696E74");
                }
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
        return null;
    }

    private IProject getProject(IResource resource) {
        if (resource != null && resource.getProject() != null) {
            return resource.getProject();
        }
        IProject selectedProject = null;
        selectedProject = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (selectedProject == null || !selectedProject.isAccessible()) {
            selectedProject = ResourcesPlugin.getWorkspace().getRoot().getProject("DVT-Settings");
        }
        return selectedProject;
    }

    private IResource getSelectedResource(ExecutionEvent event) {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (selection.getFirstElement() instanceof IResource) {
            return (IResource)selection.getFirstElement();
        }
        return null;
    }

    protected abstract void generateAndOpenFile(IProject var1, String var2);

    abstract RulesetKind getRulesetKind();

    protected boolean isCustomRuleset() {
        return this.getRulesetKind() == RulesetKind.CUSTOM;
    }

    public static void openDoc(String path) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                if (!EclipseUtils.hasWorkingBrowser()) {
                    return;
                }
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (URI)new URL("file://" + path).toURI(), (String)"ro.amiq.dvt.linter.ui.LinterHTML5ReportBrowser", (boolean)true);
                IEditorPart editorPart = DVTFileUtils.getInstance().getActiveEditor();
                if (editorPart instanceof LinterHTML5ReportBrowser) {
                    AbstractGenerateHandler.maximizeEditor((IWorkbenchPart)editorPart);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public static void maximizeEditor(IWorkbenchPart editorPart) {
        try {
            if (editorPart == null) {
                return;
            }
            IWorkbenchPartSite site = editorPart.getSite();
            if (site == null) {
                return;
            }
            IWorkbenchPage page = site.getPage();
            if (page == null) {
                return;
            }
            IWorkbenchPartReference partReference = page.getActivePartReference();
            if (partReference == null) {
                return;
            }
            page.setPartState(partReference, 1);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static class SavingDialog
    extends Dialog {
        private Text locationText;
        private Text customRulesetLocationText;
        private String customRulesetLocationString = "";
        private String locationString = "";
        private String dialogTitle;
        private String locationLabelText;
        private String dirDialogTitle;
        private String okButtonText;
        private boolean isCustomRuleset;
        private boolean isCompareReport;
        private Boolean includeSources;
        public static final int EXPORT_COMPARE_ID = 1025;
        public static final int EXPORT_CHANGES_ID = 1026;

        public SavingDialog(Shell parent, String dialogTitle, String locationLabelText, String dirDialogTitle, String actionButtonText, boolean isCustomRuleset, boolean isCompareReport) {
            super(parent);
            this.dialogTitle = dialogTitle;
            this.locationLabelText = locationLabelText;
            this.dirDialogTitle = dirDialogTitle;
            this.okButtonText = actionButtonText;
            this.isCustomRuleset = isCustomRuleset;
            this.isCompareReport = isCompareReport;
        }

        public SavingDialog(Shell parent, String dialogTitle, String locationLabelText, String dirDialogTitle, String actionButtonText, boolean isCustomRuleset, boolean isCompareReport, Boolean includeSources) {
            this(parent, dialogTitle, locationLabelText, dirDialogTitle, actionButtonText, isCustomRuleset, isCompareReport);
            this.includeSources = includeSources;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout(2, false);
            layout.marginRight = 5;
            layout.marginLeft = 10;
            container.setSize(1025, 1026);
            if (this.includeSources != null) {
                final Button includeSourcesButton = new Button(container, 32);
                includeSourcesButton.setText("Include the source files in the HTML report");
                includeSourcesButton.setSelection(this.includeSources.booleanValue());
                includeSourcesButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        includeSources = includeSourcesButton.getSelection();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            Label locationLabel = new Label(container, 0);
            locationLabel.setText(this.locationLabelText);
            locationLabel.setLocation(50, 100);
            this.locationText = new Text(container, 2048);
            this.locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.locationText.setText(this.locationString);
            this.locationText.addModifyListener(e -> {
                String location;
                Text textWidget = (Text)e.getSource();
                this.locationString = location = textWidget.getText();
            });
            Composite buttonComposite = new Composite(container, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            buttonComposite.setLayout((Layout)layout);
            buttonComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
            buttonComposite.setFont(parent.getFont());
            Button browseFileSystemButton = new Button(buttonComposite, 8);
            browseFileSystemButton.setFont(buttonComposite.getFont());
            browseFileSystemButton.setText(ExternalToolsMessages.ExternalToolsMainTab_Browse_F_ile_System____7);
            GridData gd = new GridData();
            browseFileSystemButton.setLayoutData((Object)gd);
            browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dirDialog = new DirectoryDialog(this.getShell(), 0);
                    dirDialog.setText(dirDialogTitle);
                    String dialogResult = dirDialog.open();
                    if (dialogResult != null) {
                        locationText.setText(dialogResult);
                    }
                }
            });
            if (!this.isCustomRuleset) {
                return container;
            }
            Label customRulesetLocationLabel = new Label(container, 0);
            customRulesetLocationLabel.setText("Custom XML Ruleset File:");
            customRulesetLocationLabel.setLocation(50, 100);
            this.customRulesetLocationText = new Text(container, 2048);
            this.customRulesetLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.customRulesetLocationText.setText(this.customRulesetLocationString);
            this.customRulesetLocationText.addModifyListener(e -> {
                String location;
                Text textWidget = (Text)e.getSource();
                this.customRulesetLocationString = location = textWidget.getText();
            });
            this.customRulesetLocationText.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (!customRulesetLocationText.getText().isEmpty() && customRulesetLocationText.getText().endsWith(".xml")) {
                        try {
                            File rulesetFile = new File(customRulesetLocationText.getText());
                            if (!rulesetFile.exists() || !rulesetFile.isFile()) {
                                throw new Exception();
                            }
                        }
                        catch (Exception exception) {
                            this.getButton(0).setEnabled(false);
                            return;
                        }
                        this.getButton(0).setEnabled(true);
                    } else {
                        this.getButton(0).setEnabled(false);
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            Composite customRulesetButtonsComposite = new Composite(container, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            customRulesetButtonsComposite.setLayout((Layout)layout);
            customRulesetButtonsComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
            customRulesetButtonsComposite.setFont(parent.getFont());
            Button customRulesetBrowseWorkspaceButton = new Button(customRulesetButtonsComposite, 8);
            customRulesetBrowseWorkspaceButton.setFont(customRulesetButtonsComposite.getFont());
            customRulesetBrowseWorkspaceButton.setText(ExternalToolsMessages.ExternalToolsMainTab_Browse_Wor_kspace____6);
            customRulesetBrowseWorkspaceButton.setLayoutData((Object)new GridData());
            customRulesetBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getParentShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Select XML Ruleset file:", 1);
                    dialog.setFileFilter(".xml", false);
                    dialog.open();
                    IStructuredSelection result = dialog.getResult();
                    if (result != null) {
                        Object resource = result.getFirstElement();
                        customRulesetLocationText.setText(((IFile)resource).getLocation().toOSString());
                        this.getButton(0).setEnabled(true);
                    }
                }
            });
            Button customRulesetBrowseFileSystemButton = new Button(customRulesetButtonsComposite, 8);
            customRulesetBrowseFileSystemButton.setFont(customRulesetButtonsComposite.getFont());
            customRulesetBrowseFileSystemButton.setText(ExternalToolsMessages.ExternalToolsMainTab_Browse_F_ile_System____7);
            customRulesetBrowseFileSystemButton.setLayoutData((Object)new GridData());
            customRulesetBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fileDialog = new FileDialog(this.getShell(), 0);
                    fileDialog.setText("Choose XML Ruleset file");
                    fileDialog.setFilterExtensions(new String[]{"*.xml"});
                    String dialogResult = fileDialog.open();
                    if (dialogResult != null) {
                        customRulesetLocationText.setText(dialogResult);
                    }
                    this.getButton(0).setEnabled(true);
                }
            });
            return container;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.dialogTitle);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button okButton = this.createButton(parent, 0, this.okButtonText, true);
            if (this.isCustomRuleset) {
                okButton.setEnabled(false);
            }
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            if (this.isCompareReport) {
                this.createButton(parent, 1025, "Export Compare", false);
                this.createButton(parent, 1026, "Export Changes", false);
            }
        }

        protected Point getInitialSize() {
            if (this.isCustomRuleset) {
                return new Point(600, 330);
            }
            if (this.includeSources != null) {
                return new Point(600, 250);
            }
            return new Point(600, 220);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.okPressed();
            } else if (1 == buttonId) {
                this.cancelPressed();
            } else if (1025 == buttonId) {
                this.exportComparePressed();
            } else if (1026 == buttonId) {
                this.exportChangesPressed();
            }
        }

        private void exportChangesPressed() {
            this.setReturnCode(1026);
            this.close();
        }

        private void exportComparePressed() {
            this.setReturnCode(1025);
            this.close();
        }

        protected void okPressed() {
            super.okPressed();
        }

        protected boolean isResizable() {
            return true;
        }

        public String getLocation() {
            return this.locationString;
        }

        public Boolean getIncludeSources() {
            return this.includeSources;
        }

        public void setLocation(String location) {
            this.locationString = location;
        }

        public String getCustomRulesetLocation() {
            return this.customRulesetLocationString;
        }
    }
}

