/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.generate;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.JarUtils;
import ro.amiq.vlogdt.linter.generate.AbstractGenerateHandler;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;

public abstract class AbstractGenerateXMLRulesetHandler
extends AbstractGenerateHandler {
    protected AbstractGenerateXMLRulesetHandler() {
        super("Generating XML", "Generate XML Ruleset", "XML Ruleset Location:");
    }

    @Override
    protected void generateAndOpenFile(IProject selectedProject, String customRulesetLocation) {
        try {
            JarUtils.extractFile((String)this.getRulesetKind().getXML(), RulesetKind.class, (String)this.location, (boolean)false);
            File rulesetFile = new File(String.valueOf(this.location) + "/" + this.getRulesetKind().getXML());
            IPath projectLocation = selectedProject.getLocation();
            IPath rulesetPath = Path.fromOSString((String)rulesetFile.getAbsolutePath());
            if (projectLocation != null && projectLocation.isPrefixOf(rulesetPath)) {
                IFile rulesetIFile = selectedProject.getFile(rulesetPath.makeRelativeTo(projectLocation));
                rulesetIFile.refreshLocal(0, null);
            }
            DVTFileUtils.getInstance().openEditor(rulesetFile, 0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

