/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.generate;

import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.annotations.Annotation;
import ro.amiq.vlogdt.linter.annotations.AnnotationLocation;
import ro.amiq.vlogdt.linter.annotations.AnnotationManager;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.generate.doc.LinterDocTemplateLoader;
import ro.amiq.vlogdt.linter.generate.ruleset.editor.RulesetEditorTemplateLoader;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;

public class LinterGeneratorUtils {
    public static final String RULEPOOL_XML_FILENAME = "verissimo_rule_pool.xml";
    public static final String RULEPOOL_DOC_TITLE = "Verissimo Rulepool Documentation";
    private static int fIndex;

    public static void process(OVMProject mainProject, OVMProject customRulesetProject, String templateName, String outputFile, OVMComplianceCheck.ParametersDescriptionParser parametersDescriptionParser, List<String> attributes, boolean isRulesetEditor) throws IOException, TemplateException {
        Configuration config = new Configuration();
        if (isRulesetEditor) {
            config.setTemplateLoader((TemplateLoader)new RulesetEditorTemplateLoader());
        } else {
            config.setTemplateLoader((TemplateLoader)new LinterDocTemplateLoader());
        }
        config.setTemplateUpdateDelay(0);
        BeansWrapper wrapper = (BeansWrapper)ObjectWrapper.BEANS_WRAPPER;
        wrapper.setSimpleMapWrapper(true);
        config.setObjectWrapper((ObjectWrapper)wrapper);
        Template template = config.getTemplate(templateName);
        Map<Object, Object> rootMap = new HashMap<String, Map<String, Object>>();
        Throwable throwable = null;
        Object var12_13 = null;
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(outputFile))));){
            Map<String, Object> root = LinterGeneratorUtils.createRoot(mainProject, outputFile, parametersDescriptionParser, attributes, isRulesetEditor, false, templateName);
            if (isRulesetEditor) {
                rootMap.put("all", root);
                if (customRulesetProject != null) {
                    root = LinterGeneratorUtils.createRoot(customRulesetProject, outputFile, parametersDescriptionParser, attributes, false, true, templateName);
                    rootMap.put("custom", root);
                }
            } else {
                rootMap = root;
            }
            template.process(rootMap, (Writer)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map<String, Object> createRoot(OVMProject project, String outputFile, OVMComplianceCheck.ParametersDescriptionParser parametersDescriptionParser, List<String> attributes, boolean setRulesetEditorResourcesPath, boolean loadCustomRulesetInRulesetEditor, String templateName) {
        Set<Annotation> annotations;
        AnnotationManager annotationManager;
        fIndex = 1;
        if (project == null) {
            return null;
        }
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        HashMap<String, Integer> rulesetIds = new HashMap<String, Integer>();
        rootMap.put("children", LinterGeneratorUtils.createCategories(project.getComplianceCategories(), outputFile, parametersDescriptionParser, rulesetIds, loadCustomRulesetInRulesetEditor, templateName));
        rootMap.put("attributes", attributes);
        RulesetKind rulesetKind = project.getConfiguration().getRulesetKind();
        String rulesetName = outputFile.equals("Verissimo_Linter_Rule_Pool_Doc.html") ? RULEPOOL_DOC_TITLE : project.getRulesetName();
        if (rulesetName == null) {
            rulesetName = rulesetKind.toString();
        }
        if (rulesetName.isEmpty()) {
            rulesetName = RulesetKind.VERISSIMO_ALL_UVM.toString();
        }
        boolean custom = false;
        if (rulesetKind == RulesetKind.CUSTOM) {
            custom = true;
        }
        rootMap.put("ruleset", rulesetName);
        rootMap.put("rulesetVersion", "2");
        rootMap.put("xvm", project.getLibraryKind() == 1 ? "ovm" : "uvm");
        rootMap.put("custom", custom);
        rootMap.put("date", Calendar.getInstance().getTime().toString());
        rootMap.put("user", System.getProperty("user.name"));
        rootMap.put("version", Utils.getVersion());
        if (setRulesetEditorResourcesPath) {
            rootMap.put("resources_path", "/resources/verissimo_ruleset_editor");
        } else {
            rootMap.put("resources_path", "/resources/verissimo_doc");
        }
        if (loadCustomRulesetInRulesetEditor && (annotationManager = project.getRulesetConfiguration().getAnnotationManager()) != null && (annotations = annotationManager.getAnnotations()) != null && !annotations.isEmpty()) {
            ArrayList annotationsList = new ArrayList();
            for (Annotation annotation : annotations) {
                HashMap<String, Object> annotationMap = new HashMap<String, Object>();
                annotationMap.put("name", annotation.getName());
                annotationMap.put("type", (Object)annotation.getType());
                Object[] annotationArgs = annotation.getArgs();
                if (annotationArgs != null && annotationArgs.length >= 1) {
                    annotationMap.put("arg", annotation.getArgs()[0]);
                }
                Set<AnnotationLocation> locations = annotation.getLocations();
                ArrayList<String> locationsList = new ArrayList<String>();
                for (AnnotationLocation location : locations) {
                    locationsList.add(location.toString());
                }
                annotationMap.put("locations", locationsList);
                annotationsList.add(annotationMap);
            }
            if (!annotationsList.isEmpty()) {
                rootMap.put("annotations", annotationsList);
            }
        }
        Set labels = RuleLabel.getLabelsFromCategories(project.getComplianceCategories()).stream().map(x -> x.getValue()).collect(Collectors.toSet());
        rootMap.put("labels", new TreeSet(labels));
        return rootMap;
    }

    public static List<Object> createCategories(List<OVMComplianceCategory> categories, String outputFile, OVMComplianceCheck.ParametersDescriptionParser parametersDescriptionParser, Map<String, Integer> rulesetIds, boolean isCustomRuleset, String templateName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (categories == null || categories.isEmpty()) {
            return result;
        }
        for (OVMComplianceCategory category : categories) {
            HashMap<String, Object> categoryMap = new HashMap<String, Object>();
            if (category.getChecks() == null || category.getChecks().isEmpty() || RULEPOOL_XML_FILENAME.equals(outputFile) && "Manual".equals(category.getName())) continue;
            categoryMap.put("index", fIndex++);
            categoryMap.put("type", "category");
            categoryMap.put("name", category.getName());
            categoryMap.put("description", category.getDescription());
            categoryMap.put("children", LinterGeneratorUtils.createRules(category.getChecks(), templateName, parametersDescriptionParser, rulesetIds, isCustomRuleset));
            result.add(categoryMap);
        }
        return result;
    }

    public static List<Object> createRules(List<OVMComplianceCheck> checks, String templateName, OVMComplianceCheck.ParametersDescriptionParser parametersDescriptionParser, Map<String, Integer> rulesetIds, boolean isCustomRuleset) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (checks == null || checks.isEmpty()) {
            return result;
        }
        for (OVMComplianceCheck check : checks) {
            HashMap<String, Object> checkMap = new HashMap<String, Object>();
            checkMap.put("index", fIndex++);
            checkMap.put("type", "rule");
            checkMap.put("id", check.getID());
            if (isCustomRuleset) {
                if (rulesetIds.containsKey(check.getID())) {
                    checkMap.put("rulesetId", rulesetIds.get(check.getID()));
                    rulesetIds.put(check.getID(), rulesetIds.get(check.getID()) + 1);
                } else {
                    rulesetIds.put(check.getID(), 1);
                }
                if (check.isAutocorrectable()) {
                    checkMap.put("hasAutocorrectEnabled", check.isAutoCorrectEnabled());
                }
                checkMap.put("descriptionAppend", check.getDescriptionAppend());
                Map<String, List<String>> tags = check.getAnnotationsByTagIdMap();
                if (tags != null && !tags.isEmpty()) {
                    ArrayList allTagsMap = new ArrayList();
                    for (Map.Entry<String, List<String>> tagEntry : tags.entrySet()) {
                        HashMap<String, Object> tagMap = new HashMap<String, Object>();
                        String tagKey = tagEntry.getKey();
                        List<String> tagValues = tagEntry.getValue();
                        tagMap.put("tagKey", tagKey);
                        tagMap.put("tagValues", tagValues);
                        allTagsMap.add(tagMap);
                    }
                    if (!allTagsMap.isEmpty()) {
                        checkMap.put("tags", allTagsMap);
                    }
                }
            }
            checkMap.put("name", check.getName());
            checkMap.put("title", check.getTitle());
            checkMap.put("categoryName", check.getCategory().getName());
            checkMap.put("label", RuleLabel.getValues(check.getLabels() == null || check.getLabels().isEmpty() ? null : check.getLabels()));
            checkMap.put("severity", check.getSeverity() != null ? check.getSeverity().name() : (check.getDefaultSeverity() != null ? check.getDefaultSeverity().name() : "Severity of the compilation failures"));
            checkMap.put("description", isCustomRuleset ? check.getDefaultDescription() : check.getFullDescription());
            checkMap.put("parameters", check.getParametersDescription(parametersDescriptionParser));
            checkMap.put("parameterMap", check.createParameters());
            checkMap.put("isAutocorrectable", check.isAutocorrectable());
            checkMap.put("autocorrectParameters", check.getAutocorrectParametersDescription(parametersDescriptionParser));
            checkMap.put("autocorrectParameterMap", check.createAutocorrectParameters());
            checkMap.put("date", check.getDate());
            checkMap.put("version", check.getVersion());
            checkMap.put("disable", !check.isEnabled());
            checkMap.put("rulesetInfo", check.getRulesetInfo());
            result.add(checkMap);
        }
        return result;
    }
}

