/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.guidelines.AbstractMembersCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractAdditionalMembersExtendedItemCheck
extends AbstractMembersCheck {
    public AbstractAdditionalMembersExtendedItemCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected void checkMethodContentsInExtendedItemsWithAdditionalMembers(String methodName) {
        for (RfClass seqItem : this.fOVMProject.fSequenceItems.values()) {
            AbstractMembersCheck.FieldsInfo info;
            List<RfFunction> candidates;
            RfClass parent = seqItem.getParent();
            if (parent == null || !this.fOVMProject.fSequenceItems.containsKey(parent.getFullName()) || (candidates = seqItem.getFunctionsWithPrefix(methodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)).isEmpty()) continue;
            RfFunction method = candidates.get(0);
            SuperHidVisitor superVisitor = new SuperHidVisitor(method);
            method.visitHidObject(null, superVisitor);
            if (!superVisitor.isCalledSuper()) {
                this.addHit(method, String.valueOf(methodName) + " method does not call super." + methodName);
                continue;
            }
            List<RfField> fields = seqItem.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (fields == null || fields.isEmpty() || (info = this.getFieldsInfo(seqItem, fields, methodName)) == null) continue;
            this.checkAdditionalMemberInMethod(method, info.getFieldsToCheck(), info.getFieldsToFail(), this.pCheckRegisteredFields);
        }
    }

    protected abstract void checkAdditionalMemberInMethod(RfFunction var1, List<RfField> var2, List<RfField> var3, boolean var4);

    private static class SuperHidVisitor
    extends RfHidVisitor {
        RfFunction method;
        boolean calledSuper;

        public SuperHidVisitor(RfFunction method) {
            this.method = method;
            this.calledSuper = false;
        }

        public boolean visit(RfHid rfHid) {
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            if (!rfHid.getName().equals(this.method.getName())) {
                return true;
            }
            if (rfHid.getParentAccess() == null) {
                return true;
            }
            if (!rfHid.getParentHid().getName().equals("super")) {
                return true;
            }
            this.calledSuper = true;
            return true;
        }

        public boolean isCalledSuper() {
            return this.calledSuper;
        }
    }
}

